// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object belongs to the CreatePredictor operation. If you created your predictor with CreateAutoPredictor, see DataConfig.
 *
 * The data used to train a predictor. The data includes a dataset group and any supplementary features. You specify this object in the CreatePredictor request.
 */
public class InputDataConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     */
    public val datasetGroupArn: kotlin.String = requireNotNull(builder.datasetGroupArn) { "A non-null value must be provided for datasetGroupArn" }
    /**
     * An array of supplementary features. The only supported feature is a holiday calendar.
     */
    public val supplementaryFeatures: List<SupplementaryFeature>? = builder.supplementaryFeatures

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.InputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDataConfig(")
        append("datasetGroupArn=$datasetGroupArn,")
        append("supplementaryFeatures=$supplementaryFeatures")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetGroupArn.hashCode()
        result = 31 * result + (supplementaryFeatures?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDataConfig

        if (datasetGroupArn != other.datasetGroupArn) return false
        if (supplementaryFeatures != other.supplementaryFeatures) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.InputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the dataset group.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * An array of supplementary features. The only supported feature is a holiday calendar.
         */
        public var supplementaryFeatures: List<SupplementaryFeature>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.InputDataConfig) : this() {
            this.datasetGroupArn = x.datasetGroupArn
            this.supplementaryFeatures = x.supplementaryFeatures
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.InputDataConfig = InputDataConfig(this)

        internal fun correctErrors(): Builder {
            if (datasetGroupArn == null) datasetGroupArn = ""
            return this
        }
    }
}
