// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Parameters that define how to split a dataset into training data and testing data, and the number of iterations to perform. These parameters are specified in the predefined algorithms but you can override them in the CreatePredictor request.
 */
public class EvaluationParameters private constructor(builder: Builder) {
    /**
     * The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. `BackTestWindowOffset` can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.
     *
     * `ForecastHorizon` <= `BackTestWindowOffset` < 1/2 * TARGET_TIME_SERIES dataset length
     */
    public val backTestWindowOffset: kotlin.Int? = builder.backTestWindowOffset
    /**
     * The number of times to split the input data. The default is 1. Valid values are 1 through 5.
     */
    public val numberOfBacktestWindows: kotlin.Int? = builder.numberOfBacktestWindows

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.EvaluationParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationParameters(")
        append("backTestWindowOffset=$backTestWindowOffset,")
        append("numberOfBacktestWindows=$numberOfBacktestWindows")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backTestWindowOffset ?: 0
        result = 31 * result + (numberOfBacktestWindows ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationParameters

        if (backTestWindowOffset != other.backTestWindowOffset) return false
        if (numberOfBacktestWindows != other.numberOfBacktestWindows) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.EvaluationParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. `BackTestWindowOffset` can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.
         *
         * `ForecastHorizon` <= `BackTestWindowOffset` < 1/2 * TARGET_TIME_SERIES dataset length
         */
        public var backTestWindowOffset: kotlin.Int? = null
        /**
         * The number of times to split the input data. The default is 1. Valid values are 1 through 5.
         */
        public var numberOfBacktestWindows: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.EvaluationParameters) : this() {
            this.backTestWindowOffset = x.backTestWindowOffset
            this.numberOfBacktestWindows = x.numberOfBacktestWindows
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.EvaluationParameters = EvaluationParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
