// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeForecastResponse private constructor(builder: Builder) {
    /**
     * When the forecast creation task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The ARN of the dataset group that provided the data used to train the predictor.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The estimated time remaining in minutes for the forecast job to complete.
     */
    public val estimatedTimeRemainingInMinutes: kotlin.Long? = builder.estimatedTimeRemainingInMinutes
    /**
     * The forecast ARN as specified in the request.
     */
    public val forecastArn: kotlin.String? = builder.forecastArn
    /**
     * The name of the forecast.
     */
    public val forecastName: kotlin.String? = builder.forecastName
    /**
     * The quantiles at which probabilistic forecasts were generated.
     */
    public val forecastTypes: List<String>? = builder.forecastTypes
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The ARN of the predictor used to generate the forecast.
     */
    public val predictorArn: kotlin.String? = builder.predictorArn
    /**
     * The status of the forecast. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     *
     * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The time series to include in the forecast.
     */
    public val timeSeriesSelector: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector? = builder.timeSeriesSelector

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DescribeForecastResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeForecastResponse(")
        append("creationTime=$creationTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("estimatedTimeRemainingInMinutes=$estimatedTimeRemainingInMinutes,")
        append("forecastArn=$forecastArn,")
        append("forecastName=$forecastName,")
        append("forecastTypes=$forecastTypes,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("predictorArn=$predictorArn,")
        append("status=$status,")
        append("timeSeriesSelector=$timeSeriesSelector")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeRemainingInMinutes?.hashCode() ?: 0)
        result = 31 * result + (forecastArn?.hashCode() ?: 0)
        result = 31 * result + (forecastName?.hashCode() ?: 0)
        result = 31 * result + (forecastTypes?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (predictorArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timeSeriesSelector?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeForecastResponse

        if (creationTime != other.creationTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (estimatedTimeRemainingInMinutes != other.estimatedTimeRemainingInMinutes) return false
        if (forecastArn != other.forecastArn) return false
        if (forecastName != other.forecastName) return false
        if (forecastTypes != other.forecastTypes) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (predictorArn != other.predictorArn) return false
        if (status != other.status) return false
        if (timeSeriesSelector != other.timeSeriesSelector) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DescribeForecastResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the forecast creation task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the dataset group that provided the data used to train the predictor.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The estimated time remaining in minutes for the forecast job to complete.
         */
        public var estimatedTimeRemainingInMinutes: kotlin.Long? = null
        /**
         * The forecast ARN as specified in the request.
         */
        public var forecastArn: kotlin.String? = null
        /**
         * The name of the forecast.
         */
        public var forecastName: kotlin.String? = null
        /**
         * The quantiles at which probabilistic forecasts were generated.
         */
        public var forecastTypes: List<String>? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The ARN of the predictor used to generate the forecast.
         */
        public var predictorArn: kotlin.String? = null
        /**
         * The status of the forecast. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         *
         * The `Status` of the forecast must be `ACTIVE` before you can query or export the forecast.
         */
        public var status: kotlin.String? = null
        /**
         * The time series to include in the forecast.
         */
        public var timeSeriesSelector: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DescribeForecastResponse) : this() {
            this.creationTime = x.creationTime
            this.datasetGroupArn = x.datasetGroupArn
            this.estimatedTimeRemainingInMinutes = x.estimatedTimeRemainingInMinutes
            this.forecastArn = x.forecastArn
            this.forecastName = x.forecastName
            this.forecastTypes = x.forecastTypes
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.predictorArn = x.predictorArn
            this.status = x.status
            this.timeSeriesSelector = x.timeSeriesSelector
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DescribeForecastResponse = DescribeForecastResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector] inside the given [block]
         */
        public fun timeSeriesSelector(block: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector.Builder.() -> kotlin.Unit) {
            this.timeSeriesSelector = aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
