// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the dataset import job properties used in the [ListDatasetImportJobs](https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html) operation. To get the complete set of properties, call the [DescribeDatasetImportJob](https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html) operation, and provide the `DatasetImportJobArn`.
 */
public class DatasetImportJobSummary private constructor(builder: Builder) {
    /**
     * When the dataset import job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
     *
     * If encryption is used, `DataSource` includes an Key Management Service (KMS) key.
     */
    public val dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the dataset import job.
     */
    public val datasetImportJobArn: kotlin.String? = builder.datasetImportJobArn
    /**
     * The name of the dataset import job.
     */
    public val datasetImportJobName: kotlin.String? = builder.datasetImportJobName
    /**
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     */
    public val importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = builder.importMode
    /**
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * + `CREATE_PENDING` - The `CreationTime`.
     * + `CREATE_IN_PROGRESS` - The current timestamp.
     * + `CREATE_STOPPING` - The current timestamp.
     * + `CREATE_STOPPED` - When the job stopped.
     * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * If an error occurred, an informational message about the error.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status of the dataset import job. States include:
     * + `ACTIVE`
     * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
     * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
     * + `CREATE_STOPPING`, `CREATE_STOPPED`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.DatasetImportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetImportJobSummary(")
        append("creationTime=$creationTime,")
        append("dataSource=$dataSource,")
        append("datasetImportJobArn=$datasetImportJobArn,")
        append("datasetImportJobName=$datasetImportJobName,")
        append("importMode=$importMode,")
        append("lastModificationTime=$lastModificationTime,")
        append("message=$message,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobName?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetImportJobSummary

        if (creationTime != other.creationTime) return false
        if (dataSource != other.dataSource) return false
        if (datasetImportJobArn != other.datasetImportJobArn) return false
        if (datasetImportJobName != other.datasetImportJobName) return false
        if (importMode != other.importMode) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (message != other.message) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.DatasetImportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the dataset import job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         *
         * If encryption is used, `DataSource` includes an Key Management Service (KMS) key.
         */
        public var dataSource: aws.sdk.kotlin.services.forecast.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset import job.
         */
        public var datasetImportJobArn: kotlin.String? = null
        /**
         * The name of the dataset import job.
         */
        public var datasetImportJobName: kotlin.String? = null
        /**
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         */
        public var importMode: aws.sdk.kotlin.services.forecast.model.ImportMode? = null
        /**
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * + `CREATE_PENDING` - The `CreationTime`.
         * + `CREATE_IN_PROGRESS` - The current timestamp.
         * + `CREATE_STOPPING` - The current timestamp.
         * + `CREATE_STOPPED` - When the job stopped.
         * + `ACTIVE` or `CREATE_FAILED` - When the job finished or failed.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If an error occurred, an informational message about the error.
         */
        public var message: kotlin.String? = null
        /**
         * The status of the dataset import job. States include:
         * + `ACTIVE`
         * + `CREATE_PENDING`, `CREATE_IN_PROGRESS`, `CREATE_FAILED`
         * + `DELETE_PENDING`, `DELETE_IN_PROGRESS`, `DELETE_FAILED`
         * + `CREATE_STOPPING`, `CREATE_STOPPED`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.DatasetImportJobSummary) : this() {
            this.creationTime = x.creationTime
            this.dataSource = x.dataSource
            this.datasetImportJobArn = x.datasetImportJobArn
            this.datasetImportJobName = x.datasetImportJobName
            this.importMode = x.importMode
            this.lastModificationTime = x.lastModificationTime
            this.message = x.message
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.DatasetImportJobSummary = DatasetImportJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.forecast.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.forecast.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
