// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePredictorRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the algorithm to use for model training. Required if `PerformAutoML` is not set to `true`.
     *
     * **Supported algorithms:**
     * + `arn:aws:forecast:::algorithm/ARIMA`
     * + `arn:aws:forecast:::algorithm/CNN-QR`
     * + `arn:aws:forecast:::algorithm/Deep_AR_Plus`
     * + `arn:aws:forecast:::algorithm/ETS`
     * + `arn:aws:forecast:::algorithm/NPTS`
     * + `arn:aws:forecast:::algorithm/Prophet`
     */
    public val algorithmArn: kotlin.String? = builder.algorithmArn
    /**
     * The `LatencyOptimized` AutoML override strategy is only available in private beta. Contact Amazon Web Services Support or your account manager to learn more about access privileges.
     *
     * Used to overide the default AutoML strategy, which is to optimize predictor accuracy. To apply an AutoML strategy that minimizes training time, use `LatencyOptimized`.
     *
     * This parameter is only valid for predictors trained using AutoML.
     */
    public val autoMlOverrideStrategy: aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy? = builder.autoMlOverrideStrategy
    /**
     * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.
     */
    public val evaluationParameters: aws.sdk.kotlin.services.forecast.model.EvaluationParameters? = builder.evaluationParameters
    /**
     * The featurization configuration.
     */
    public val featurizationConfig: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig? = builder.featurizationConfig
    /**
     * Specifies the number of time-steps that the model is trained to predict. The forecast horizon is also called the prediction length.
     *
     * For example, if you configure a dataset for daily data collection (using the `DataFrequency` parameter of the CreateDataset operation) and set the forecast horizon to 10, the model returns predictions for 10 days.
     *
     * The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.
     */
    public val forecastHorizon: kotlin.Int? = builder.forecastHorizon
    /**
     * Specifies the forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with `mean`.
     *
     * The default value is `["0.10", "0.50", "0.9"]`.
     */
    public val forecastTypes: List<String>? = builder.forecastTypes
    /**
     * Provides hyperparameter override values for the algorithm. If you don't provide this parameter, Amazon Forecast uses default values. The individual algorithms specify which hyperparameters support hyperparameter optimization (HPO). For more information, see aws-forecast-choosing-recipes.
     *
     * If you included the `HPOConfig` object, you must set `PerformHPO` to true.
     */
    public val hpoConfig: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig? = builder.hpoConfig
    /**
     * Describes the dataset group that contains the data to use to train the predictor.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.forecast.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The accuracy metric used to optimize the predictor.
     */
    public val optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = builder.optimizationMetric
    /**
     * Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates the algorithms it provides and chooses the best algorithm and configuration for your training dataset.
     *
     * The default value is `false`. In this case, you are required to specify an algorithm.
     *
     * Set `PerformAutoML` to `true` to have Amazon Forecast perform AutoML. This is a good option if you aren't sure which algorithm is suitable for your training data. In this case, `PerformHPO` must be false.
     */
    public val performAutoMl: kotlin.Boolean? = builder.performAutoMl
    /**
     * Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter values for your training data. The process of performing HPO is known as running a hyperparameter tuning job.
     *
     * The default value is `false`. In this case, Amazon Forecast uses default hyperparameter values from the chosen algorithm.
     *
     * To override the default values, set `PerformHPO` to `true` and, optionally, supply the HyperParameterTuningJobConfig object. The tuning job specifies a metric to optimize, which hyperparameters participate in tuning, and the valid range for each tunable hyperparameter. In this case, you are required to specify an algorithm and `PerformAutoML` must be false.
     *
     * The following algorithms support HPO:
     * + DeepAR+
     * + CNN-QR
     */
    public val performHpo: kotlin.Boolean? = builder.performHpo
    /**
     * A name for the predictor.
     */
    public val predictorName: kotlin.String? = builder.predictorName
    /**
     * The optional metadata that you apply to the predictor to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The hyperparameters to override for model training. The hyperparameters that you can override are listed in the individual algorithms. For the list of supported algorithms, see aws-forecast-choosing-recipes.
     */
    public val trainingParameters: Map<String, String>? = builder.trainingParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePredictorRequest(")
        append("algorithmArn=$algorithmArn,")
        append("autoMlOverrideStrategy=$autoMlOverrideStrategy,")
        append("encryptionConfig=$encryptionConfig,")
        append("evaluationParameters=$evaluationParameters,")
        append("featurizationConfig=$featurizationConfig,")
        append("forecastHorizon=$forecastHorizon,")
        append("forecastTypes=$forecastTypes,")
        append("hpoConfig=$hpoConfig,")
        append("inputDataConfig=$inputDataConfig,")
        append("optimizationMetric=$optimizationMetric,")
        append("performAutoMl=$performAutoMl,")
        append("performHpo=$performHpo,")
        append("predictorName=$predictorName,")
        append("tags=$tags,")
        append("trainingParameters=$trainingParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmArn?.hashCode() ?: 0
        result = 31 * result + (autoMlOverrideStrategy?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (evaluationParameters?.hashCode() ?: 0)
        result = 31 * result + (featurizationConfig?.hashCode() ?: 0)
        result = 31 * result + (forecastHorizon ?: 0)
        result = 31 * result + (forecastTypes?.hashCode() ?: 0)
        result = 31 * result + (hpoConfig?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (optimizationMetric?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl?.hashCode() ?: 0)
        result = 31 * result + (performHpo?.hashCode() ?: 0)
        result = 31 * result + (predictorName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePredictorRequest

        if (algorithmArn != other.algorithmArn) return false
        if (autoMlOverrideStrategy != other.autoMlOverrideStrategy) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (evaluationParameters != other.evaluationParameters) return false
        if (featurizationConfig != other.featurizationConfig) return false
        if (forecastHorizon != other.forecastHorizon) return false
        if (forecastTypes != other.forecastTypes) return false
        if (hpoConfig != other.hpoConfig) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (optimizationMetric != other.optimizationMetric) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performHpo != other.performHpo) return false
        if (predictorName != other.predictorName) return false
        if (tags != other.tags) return false
        if (trainingParameters != other.trainingParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the algorithm to use for model training. Required if `PerformAutoML` is not set to `true`.
         *
         * **Supported algorithms:**
         * + `arn:aws:forecast:::algorithm/ARIMA`
         * + `arn:aws:forecast:::algorithm/CNN-QR`
         * + `arn:aws:forecast:::algorithm/Deep_AR_Plus`
         * + `arn:aws:forecast:::algorithm/ETS`
         * + `arn:aws:forecast:::algorithm/NPTS`
         * + `arn:aws:forecast:::algorithm/Prophet`
         */
        public var algorithmArn: kotlin.String? = null
        /**
         * The `LatencyOptimized` AutoML override strategy is only available in private beta. Contact Amazon Web Services Support or your account manager to learn more about access privileges.
         *
         * Used to overide the default AutoML strategy, which is to optimize predictor accuracy. To apply an AutoML strategy that minimizes training time, use `LatencyOptimized`.
         *
         * This parameter is only valid for predictors trained using AutoML.
         */
        public var autoMlOverrideStrategy: aws.sdk.kotlin.services.forecast.model.AutoMlOverrideStrategy? = null
        /**
         * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = null
        /**
         * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.
         */
        public var evaluationParameters: aws.sdk.kotlin.services.forecast.model.EvaluationParameters? = null
        /**
         * The featurization configuration.
         */
        public var featurizationConfig: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig? = null
        /**
         * Specifies the number of time-steps that the model is trained to predict. The forecast horizon is also called the prediction length.
         *
         * For example, if you configure a dataset for daily data collection (using the `DataFrequency` parameter of the CreateDataset operation) and set the forecast horizon to 10, the model returns predictions for 10 days.
         *
         * The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.
         */
        public var forecastHorizon: kotlin.Int? = null
        /**
         * Specifies the forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with `mean`.
         *
         * The default value is `["0.10", "0.50", "0.9"]`.
         */
        public var forecastTypes: List<String>? = null
        /**
         * Provides hyperparameter override values for the algorithm. If you don't provide this parameter, Amazon Forecast uses default values. The individual algorithms specify which hyperparameters support hyperparameter optimization (HPO). For more information, see aws-forecast-choosing-recipes.
         *
         * If you included the `HPOConfig` object, you must set `PerformHPO` to true.
         */
        public var hpoConfig: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig? = null
        /**
         * Describes the dataset group that contains the data to use to train the predictor.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.forecast.model.InputDataConfig? = null
        /**
         * The accuracy metric used to optimize the predictor.
         */
        public var optimizationMetric: aws.sdk.kotlin.services.forecast.model.OptimizationMetric? = null
        /**
         * Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates the algorithms it provides and chooses the best algorithm and configuration for your training dataset.
         *
         * The default value is `false`. In this case, you are required to specify an algorithm.
         *
         * Set `PerformAutoML` to `true` to have Amazon Forecast perform AutoML. This is a good option if you aren't sure which algorithm is suitable for your training data. In this case, `PerformHPO` must be false.
         */
        public var performAutoMl: kotlin.Boolean? = null
        /**
         * Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter values for your training data. The process of performing HPO is known as running a hyperparameter tuning job.
         *
         * The default value is `false`. In this case, Amazon Forecast uses default hyperparameter values from the chosen algorithm.
         *
         * To override the default values, set `PerformHPO` to `true` and, optionally, supply the HyperParameterTuningJobConfig object. The tuning job specifies a metric to optimize, which hyperparameters participate in tuning, and the valid range for each tunable hyperparameter. In this case, you are required to specify an algorithm and `PerformAutoML` must be false.
         *
         * The following algorithms support HPO:
         * + DeepAR+
         * + CNN-QR
         */
        public var performHpo: kotlin.Boolean? = null
        /**
         * A name for the predictor.
         */
        public var predictorName: kotlin.String? = null
        /**
         * The optional metadata that you apply to the predictor to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The hyperparameters to override for model training. The hyperparameters that you can override are listed in the individual algorithms. For the list of supported algorithms, see aws-forecast-choosing-recipes.
         */
        public var trainingParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest) : this() {
            this.algorithmArn = x.algorithmArn
            this.autoMlOverrideStrategy = x.autoMlOverrideStrategy
            this.encryptionConfig = x.encryptionConfig
            this.evaluationParameters = x.evaluationParameters
            this.featurizationConfig = x.featurizationConfig
            this.forecastHorizon = x.forecastHorizon
            this.forecastTypes = x.forecastTypes
            this.hpoConfig = x.hpoConfig
            this.inputDataConfig = x.inputDataConfig
            this.optimizationMetric = x.optimizationMetric
            this.performAutoMl = x.performAutoMl
            this.performHpo = x.performHpo
            this.predictorName = x.predictorName
            this.tags = x.tags
            this.trainingParameters = x.trainingParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreatePredictorRequest = CreatePredictorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.forecast.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.forecast.model.EncryptionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EvaluationParameters] inside the given [block]
         */
        public fun evaluationParameters(block: aws.sdk.kotlin.services.forecast.model.EvaluationParameters.Builder.() -> kotlin.Unit) {
            this.evaluationParameters = aws.sdk.kotlin.services.forecast.model.EvaluationParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.FeaturizationConfig] inside the given [block]
         */
        public fun featurizationConfig(block: aws.sdk.kotlin.services.forecast.model.FeaturizationConfig.Builder.() -> kotlin.Unit) {
            this.featurizationConfig = aws.sdk.kotlin.services.forecast.model.FeaturizationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        public fun hpoConfig(block: aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hpoConfig = aws.sdk.kotlin.services.forecast.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.forecast.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.forecast.model.InputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
