// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateForecastRequest private constructor(builder: Builder) {
    /**
     * A name for the forecast.
     */
    public val forecastName: kotlin.String? = builder.forecastName
    /**
     * The quantiles at which probabilistic forecasts are generated. **You can currently specify up to 5 quantiles per forecast**. Accepted values include `0.01 to 0.99` (increments of .01 only) and `mean`. The mean forecast is different from the median (0.50) when the distribution is not symmetric (for example, Beta and Negative Binomial).
     *
     * The default quantiles are the quantiles you specified during predictor creation. If you didn't specify quantiles, the default values are `["0.1", "0.5", "0.9"]`.
     */
    public val forecastTypes: List<String>? = builder.forecastTypes
    /**
     * The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
     */
    public val predictorArn: kotlin.String? = builder.predictorArn
    /**
     * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Defines the set of time series that are used to create the forecasts in a `TimeSeriesIdentifiers` object.
     *
     * The `TimeSeriesIdentifiers` object needs the following information:
     * + `DataSource`
     * + `Format`
     * + `Schema`
     */
    public val timeSeriesSelector: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector? = builder.timeSeriesSelector

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateForecastRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateForecastRequest(")
        append("forecastName=$forecastName,")
        append("forecastTypes=$forecastTypes,")
        append("predictorArn=$predictorArn,")
        append("tags=$tags,")
        append("timeSeriesSelector=$timeSeriesSelector")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = forecastName?.hashCode() ?: 0
        result = 31 * result + (forecastTypes?.hashCode() ?: 0)
        result = 31 * result + (predictorArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeSeriesSelector?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateForecastRequest

        if (forecastName != other.forecastName) return false
        if (forecastTypes != other.forecastTypes) return false
        if (predictorArn != other.predictorArn) return false
        if (tags != other.tags) return false
        if (timeSeriesSelector != other.timeSeriesSelector) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateForecastRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A name for the forecast.
         */
        public var forecastName: kotlin.String? = null
        /**
         * The quantiles at which probabilistic forecasts are generated. **You can currently specify up to 5 quantiles per forecast**. Accepted values include `0.01 to 0.99` (increments of .01 only) and `mean`. The mean forecast is different from the median (0.50) when the distribution is not symmetric (for example, Beta and Negative Binomial).
         *
         * The default quantiles are the quantiles you specified during predictor creation. If you didn't specify quantiles, the default values are `["0.1", "0.5", "0.9"]`.
         */
        public var forecastTypes: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
         */
        public var predictorArn: kotlin.String? = null
        /**
         * The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * Defines the set of time series that are used to create the forecasts in a `TimeSeriesIdentifiers` object.
         *
         * The `TimeSeriesIdentifiers` object needs the following information:
         * + `DataSource`
         * + `Format`
         * + `Schema`
         */
        public var timeSeriesSelector: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateForecastRequest) : this() {
            this.forecastName = x.forecastName
            this.forecastTypes = x.forecastTypes
            this.predictorArn = x.predictorArn
            this.tags = x.tags
            this.timeSeriesSelector = x.timeSeriesSelector
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateForecastRequest = CreateForecastRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector] inside the given [block]
         */
        public fun timeSeriesSelector(block: aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector.Builder.() -> kotlin.Unit) {
            this.timeSeriesSelector = aws.sdk.kotlin.services.forecast.model.TimeSeriesSelector.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
