// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDatasetRequest private constructor(builder: Builder) {
    /**
     * The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.
     *
     * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
     * + Minute - 1-59
     * + Hour - 1-23
     * + Day - 1-6
     * + Week - 1-4
     * + Month - 1-11
     * + Year - 1
     *
     * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
     */
    public val dataFrequency: kotlin.String? = builder.dataFrequency
    /**
     * A name for the dataset.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * The dataset type. Valid values depend on the chosen `Domain`.
     */
    public val datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = builder.datasetType
    /**
     * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value specified for the `Domain` parameter of the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation must match.
     *
     * The `Domain` and `DatasetType` that you choose determine the fields that must be present in the training data that you import to the dataset. For example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as the `DatasetType`, Amazon Forecast requires `item_id`, `timestamp`, and `demand` fields to be present in your data. For more information, see [Importing datasets](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
     */
    public val domain: aws.sdk.kotlin.services.forecast.model.Domain? = builder.domain
    /**
     * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html).
     */
    public val schema: aws.sdk.kotlin.services.forecast.model.Schema? = builder.schema
    /**
     * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetRequest(")
        append("dataFrequency=$dataFrequency,")
        append("datasetName=$datasetName,")
        append("datasetType=$datasetType,")
        append("domain=$domain,")
        append("encryptionConfig=$encryptionConfig,")
        append("schema=$schema,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataFrequency?.hashCode() ?: 0
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetRequest

        if (dataFrequency != other.dataFrequency) return false
        if (datasetName != other.datasetName) return false
        if (datasetType != other.datasetType) return false
        if (domain != other.domain) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (schema != other.schema) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.
         *
         * Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates every day and "15min" indicates every 15 minutes. You cannot specify a value that would overlap with the next larger frequency. That means, for example, you cannot specify a frequency of 60 minutes, because that is equivalent to 1 hour. The valid values for each frequency are the following:
         * + Minute - 1-59
         * + Hour - 1-23
         * + Day - 1-6
         * + Week - 1-4
         * + Month - 1-11
         * + Year - 1
         *
         * Thus, if you want every other week forecasts, specify "2W". Or, if you want quarterly forecasts, you specify "3M".
         */
        public var dataFrequency: kotlin.String? = null
        /**
         * A name for the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The dataset type. Valid values depend on the chosen `Domain`.
         */
        public var datasetType: aws.sdk.kotlin.services.forecast.model.DatasetType? = null
        /**
         * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value specified for the `Domain` parameter of the [CreateDatasetGroup](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html) operation must match.
         *
         * The `Domain` and `DatasetType` that you choose determine the fields that must be present in the training data that you import to the dataset. For example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as the `DatasetType`, Amazon Forecast requires `item_id`, `timestamp`, and `demand` fields to be present in your data. For more information, see [Importing datasets](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
         */
        public var domain: aws.sdk.kotlin.services.forecast.model.Domain? = null
        /**
         * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.forecast.model.EncryptionConfig? = null
        /**
         * The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html).
         */
        public var schema: aws.sdk.kotlin.services.forecast.model.Schema? = null
        /**
         * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest) : this() {
            this.dataFrequency = x.dataFrequency
            this.datasetName = x.datasetName
            this.datasetType = x.datasetType
            this.domain = x.domain
            this.encryptionConfig = x.encryptionConfig
            this.schema = x.schema
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateDatasetRequest = CreateDatasetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.forecast.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.forecast.model.EncryptionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.forecast.model.Schema] inside the given [block]
         */
        public fun schema(block: aws.sdk.kotlin.services.forecast.model.Schema.Builder.() -> kotlin.Unit) {
            this.schema = aws.sdk.kotlin.services.forecast.model.Schema.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
