// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDatasetGroupRequest private constructor(builder: Builder) {
    /**
     * An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
     */
    public val datasetArns: List<String>? = builder.datasetArns
    /**
     * A name for the dataset group.
     */
    public val datasetGroupName: kotlin.String? = builder.datasetGroupName
    /**
     * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the `Domain` parameter of the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation must match.
     *
     * The `Domain` and `DatasetType` that you choose determine the fields that must be present in training data that you import to a dataset. For example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as the `DatasetType`, Amazon Forecast requires that `item_id`, `timestamp`, and `demand` fields are present in your data. For more information, see [Dataset groups](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
     */
    public val domain: aws.sdk.kotlin.services.forecast.model.Domain? = builder.domain
    /**
     * The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetGroupRequest(")
        append("datasetArns=$datasetArns,")
        append("datasetGroupName=$datasetGroupName,")
        append("domain=$domain,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetArns?.hashCode() ?: 0
        result = 31 * result + (datasetGroupName?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetGroupRequest

        if (datasetArns != other.datasetArns) return false
        if (datasetGroupName != other.datasetGroupName) return false
        if (domain != other.domain) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
         */
        public var datasetArns: List<String>? = null
        /**
         * A name for the dataset group.
         */
        public var datasetGroupName: kotlin.String? = null
        /**
         * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the `Domain` parameter of the [CreateDataset](https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html) operation must match.
         *
         * The `Domain` and `DatasetType` that you choose determine the fields that must be present in training data that you import to a dataset. For example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as the `DatasetType`, Amazon Forecast requires that `item_id`, `timestamp`, and `demand` fields are present in your data. For more information, see [Dataset groups](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
         */
        public var domain: aws.sdk.kotlin.services.forecast.model.Domain? = null
        /**
         * The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for keys as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has `aws` as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of `aws` do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupRequest) : this() {
            this.datasetArns = x.datasetArns
            this.datasetGroupName = x.datasetGroupName
            this.domain = x.domain
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.CreateDatasetGroupRequest = CreateDatasetGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
