// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the method used to transform attributes.
 *
 * The following is an example using the RETAIL domain:
 *
 * `{`
 *
 * `"AttributeName": "demand",`
 *
 * `"Transformations": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}`
 *
 * `}`
 */
public class AttributeConfig private constructor(builder: Builder) {
    /**
     * The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is `demand`.
     */
    public val attributeName: kotlin.String = requireNotNull(builder.attributeName) { "A non-null value must be provided for attributeName" }
    /**
     * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.
     *
     * The following list shows the parameters and their valid values for the "filling" featurization method for a **Target Time Series** dataset. Default values are bolded.
     * + `aggregation`: **sum**, `avg`, `first`, `min`, `max`
     * + `frontfill`: **none**
     * + `middlefill`: **zero**, `nan` (not a number), `value`, `median`, `mean`, `min`, `max`
     * + `backfill`: **zero**, `nan`, `value`, `median`, `mean`, `min`, `max`
     *
     * The following list shows the parameters and their valid values for a **Related Time Series** featurization method (there are no defaults):
     * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
     *
     * To set a filling method to a specific value, set the fill parameter to `value` and define the value in a corresponding `_value` parameter. For example, to set backfilling to a value of 2, include the following: `"backfill": "value"` and `"backfill_value":"2"`.
     */
    public val transformations: Map<String, String> = requireNotNull(builder.transformations) { "A non-null value must be provided for transformations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecast.model.AttributeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeConfig(")
        append("attributeName=$attributeName,")
        append("transformations=$transformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName.hashCode()
        result = 31 * result + (transformations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeConfig

        if (attributeName != other.attributeName) return false
        if (transformations != other.transformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecast.model.AttributeConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target time series and the related time series datasets. For example, for the RETAIL domain, the target is `demand`.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.
         *
         * The following list shows the parameters and their valid values for the "filling" featurization method for a **Target Time Series** dataset. Default values are bolded.
         * + `aggregation`: **sum**, `avg`, `first`, `min`, `max`
         * + `frontfill`: **none**
         * + `middlefill`: **zero**, `nan` (not a number), `value`, `median`, `mean`, `min`, `max`
         * + `backfill`: **zero**, `nan`, `value`, `median`, `mean`, `min`, `max`
         *
         * The following list shows the parameters and their valid values for a **Related Time Series** featurization method (there are no defaults):
         * + `middlefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `backfill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         * + `futurefill`: `zero`, `value`, `median`, `mean`, `min`, `max`
         *
         * To set a filling method to a specific value, set the fill parameter to `value` and define the value in a corresponding `_value` parameter. For example, to set backfilling to a value of 2, include the following: `"backfill": "value"` and `"backfill_value":"2"`.
         */
        public var transformations: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecast.model.AttributeConfig) : this() {
            this.attributeName = x.attributeName
            this.transformations = x.transformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecast.model.AttributeConfig = AttributeConfig(this)

        internal fun correctErrors(): Builder {
            if (attributeName == null) attributeName = ""
            if (transformations == null) transformations = emptyMap()
            return this
        }
    }
}
