// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fis.model.FisException
import aws.sdk.kotlin.services.fis.model.GetTargetResourceTypeResponse
import aws.sdk.kotlin.services.fis.model.TargetResourceType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTargetResourceTypeOperationDeserializer: HttpDeserialize<GetTargetResourceTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTargetResourceTypeResponse {
        if (!response.status.isSuccess()) {
            throwGetTargetResourceTypeError(context, response)
        }
        val builder = GetTargetResourceTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTargetResourceTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTargetResourceTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FisException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTargetResourceTypeOperationBody(builder: GetTargetResourceTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TARGETRESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("targetResourceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TARGETRESOURCETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TARGETRESOURCETYPE_DESCRIPTOR.index -> builder.targetResourceType = deserializeTargetResourceTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
