// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an experiment template.
 */
class ExperimentTemplate private constructor(builder: Builder) {
    /**
     * The actions for the experiment.
     */
    val actions: Map<String, ExperimentTemplateAction>? = builder.actions
    /**
     * The time the experiment template was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description for the experiment template.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of the experiment template.
     */
    val id: kotlin.String? = builder.id
    /**
     * The time the experiment template was last updated.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The Amazon Resource Name (ARN) of an IAM role.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The stop conditions for the experiment.
     */
    val stopConditions: List<ExperimentTemplateStopCondition>? = builder.stopConditions
    /**
     * The tags for the experiment template.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The targets for the experiment.
     */
    val targets: Map<String, ExperimentTemplateTarget>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fis.model.ExperimentTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExperimentTemplate(")
        append("actions=$actions,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("roleArn=$roleArn,")
        append("stopConditions=$stopConditions,")
        append("tags=$tags,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stopConditions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExperimentTemplate

        if (actions != other.actions) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (roleArn != other.roleArn) return false
        if (stopConditions != other.stopConditions) return false
        if (tags != other.tags) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fis.model.ExperimentTemplate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The actions for the experiment.
         */
        var actions: Map<String, ExperimentTemplateAction>? = null
        /**
         * The time the experiment template was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the experiment template.
         */
        var description: kotlin.String? = null
        /**
         * The ID of the experiment template.
         */
        var id: kotlin.String? = null
        /**
         * The time the experiment template was last updated.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role.
         */
        var roleArn: kotlin.String? = null
        /**
         * The stop conditions for the experiment.
         */
        var stopConditions: List<ExperimentTemplateStopCondition>? = null
        /**
         * The tags for the experiment template.
         */
        var tags: Map<String, String>? = null
        /**
         * The targets for the experiment.
         */
        var targets: Map<String, ExperimentTemplateTarget>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fis.model.ExperimentTemplate) : this() {
            this.actions = x.actions
            this.creationTime = x.creationTime
            this.description = x.description
            this.id = x.id
            this.lastUpdateTime = x.lastUpdateTime
            this.roleArn = x.roleArn
            this.stopConditions = x.stopConditions
            this.tags = x.tags
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fis.model.ExperimentTemplate = ExperimentTemplate(this)
    }
}
