// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the action for an experiment.
 */
class ExperimentAction private constructor(builder: Builder) {
    /**
     * The ID of the action.
     */
    val actionId: kotlin.String? = builder.actionId
    /**
     * The description for the action.
     */
    val description: kotlin.String? = builder.description
    /**
     * The time that the action ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The parameters for the action.
     */
    val parameters: Map<String, String>? = builder.parameters
    /**
     * The name of the action that must be completed before this action starts.
     */
    val startAfter: List<String>? = builder.startAfter
    /**
     * The time that the action started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the action.
     */
    val state: aws.sdk.kotlin.services.fis.model.ExperimentActionState? = builder.state
    /**
     * The targets for the action.
     */
    val targets: Map<String, String>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fis.model.ExperimentAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExperimentAction(")
        append("actionId=$actionId,")
        append("description=$description,")
        append("endTime=$endTime,")
        append("parameters=$parameters,")
        append("startAfter=$startAfter,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (startAfter?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExperimentAction

        if (actionId != other.actionId) return false
        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (parameters != other.parameters) return false
        if (startAfter != other.startAfter) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fis.model.ExperimentAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the action.
         */
        var actionId: kotlin.String? = null
        /**
         * The description for the action.
         */
        var description: kotlin.String? = null
        /**
         * The time that the action ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The parameters for the action.
         */
        var parameters: Map<String, String>? = null
        /**
         * The name of the action that must be completed before this action starts.
         */
        var startAfter: List<String>? = null
        /**
         * The time that the action started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the action.
         */
        var state: aws.sdk.kotlin.services.fis.model.ExperimentActionState? = null
        /**
         * The targets for the action.
         */
        var targets: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fis.model.ExperimentAction) : this() {
            this.actionId = x.actionId
            this.description = x.description
            this.endTime = x.endTime
            this.parameters = x.parameters
            this.startAfter = x.startAfter
            this.startTime = x.startTime
            this.state = x.state
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fis.model.ExperimentAction = ExperimentAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.fis.model.ExperimentActionState] inside the given [block]
         */
        fun state(block: aws.sdk.kotlin.services.fis.model.ExperimentActionState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.fis.model.ExperimentActionState.invoke(block)
        }
    }
}
