// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.fis.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.fis.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * Fault Injection Simulator is a managed service that enables you to perform fault injection
 * experiments on your Amazon Web Services workloads. For more information, see the <a href="https://docs.aws.amazon.com/fis/latest/userguide/">Fault Injection Simulator User Guide.
 */
interface FisClient : SdkClient {

    override val serviceName: String
        get() = "fis"
    /**
     * FisClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): FisClient {
            val config = Config.Builder().apply(block).build()
            return DefaultFisClient(config)
        }

        operator fun invoke(config: Config): FisClient = DefaultFisClient(config)

        /**
         * Construct a [FisClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): FisClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultFisClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an experiment template.
     * An experiment template includes the following components:
     *
     *
     *
     * Targets: A target can be a specific resource in
     * your Amazon Web Services environment, or one or more resources that match criteria that you
     * specify, for example, resources that have specific tags.
     *
     *
     * Actions: The actions to carry out on the
     * target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.
     *
     *
     * Stop conditions: If a stop condition is
     * triggered while an experiment is running, the experiment is automatically
     * stopped. You can define a stop condition as a CloudWatch alarm.
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates
     * in the Fault Injection Simulator User Guide.
     */
    suspend fun createExperimentTemplate(input: CreateExperimentTemplateRequest): CreateExperimentTemplateResponse

    /**
     * Creates an experiment template.
     * An experiment template includes the following components:
     *
     *
     *
     * Targets: A target can be a specific resource in
     * your Amazon Web Services environment, or one or more resources that match criteria that you
     * specify, for example, resources that have specific tags.
     *
     *
     * Actions: The actions to carry out on the
     * target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.
     *
     *
     * Stop conditions: If a stop condition is
     * triggered while an experiment is running, the experiment is automatically
     * stopped. You can define a stop condition as a CloudWatch alarm.
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates
     * in the Fault Injection Simulator User Guide.
     */
    suspend fun createExperimentTemplate(block: CreateExperimentTemplateRequest.Builder.() -> Unit) = createExperimentTemplate(CreateExperimentTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified experiment template.
     */
    suspend fun deleteExperimentTemplate(input: DeleteExperimentTemplateRequest): DeleteExperimentTemplateResponse

    /**
     * Deletes the specified experiment template.
     */
    suspend fun deleteExperimentTemplate(block: DeleteExperimentTemplateRequest.Builder.() -> Unit) = deleteExperimentTemplate(DeleteExperimentTemplateRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified FIS action.
     */
    suspend fun getAction(input: GetActionRequest): GetActionResponse

    /**
     * Gets information about the specified FIS action.
     */
    suspend fun getAction(block: GetActionRequest.Builder.() -> Unit) = getAction(GetActionRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified experiment.
     */
    suspend fun getExperiment(input: GetExperimentRequest): GetExperimentResponse

    /**
     * Gets information about the specified experiment.
     */
    suspend fun getExperiment(block: GetExperimentRequest.Builder.() -> Unit) = getExperiment(GetExperimentRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified experiment template.
     */
    suspend fun getExperimentTemplate(input: GetExperimentTemplateRequest): GetExperimentTemplateResponse

    /**
     * Gets information about the specified experiment template.
     */
    suspend fun getExperimentTemplate(block: GetExperimentTemplateRequest.Builder.() -> Unit) = getExperimentTemplate(GetExperimentTemplateRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified resource type.
     */
    suspend fun getTargetResourceType(input: GetTargetResourceTypeRequest): GetTargetResourceTypeResponse

    /**
     * Gets information about the specified resource type.
     */
    suspend fun getTargetResourceType(block: GetTargetResourceTypeRequest.Builder.() -> Unit) = getTargetResourceType(GetTargetResourceTypeRequest.Builder().apply(block).build())

    /**
     * Lists the available FIS actions.
     */
    suspend fun listActions(input: ListActionsRequest): ListActionsResponse

    /**
     * Lists the available FIS actions.
     */
    suspend fun listActions(block: ListActionsRequest.Builder.() -> Unit) = listActions(ListActionsRequest.Builder().apply(block).build())

    /**
     * Lists your experiment templates.
     */
    suspend fun listExperimentTemplates(input: ListExperimentTemplatesRequest): ListExperimentTemplatesResponse

    /**
     * Lists your experiment templates.
     */
    suspend fun listExperimentTemplates(block: ListExperimentTemplatesRequest.Builder.() -> Unit) = listExperimentTemplates(ListExperimentTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists your experiments.
     */
    suspend fun listExperiments(input: ListExperimentsRequest): ListExperimentsResponse

    /**
     * Lists your experiments.
     */
    suspend fun listExperiments(block: ListExperimentsRequest.Builder.() -> Unit) = listExperiments(ListExperimentsRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the target resource types.
     */
    suspend fun listTargetResourceTypes(input: ListTargetResourceTypesRequest): ListTargetResourceTypesResponse

    /**
     * Lists the target resource types.
     */
    suspend fun listTargetResourceTypes(block: ListTargetResourceTypesRequest.Builder.() -> Unit) = listTargetResourceTypes(ListTargetResourceTypesRequest.Builder().apply(block).build())

    /**
     * Starts running an experiment from the specified experiment template.
     */
    suspend fun startExperiment(input: StartExperimentRequest): StartExperimentResponse

    /**
     * Starts running an experiment from the specified experiment template.
     */
    suspend fun startExperiment(block: StartExperimentRequest.Builder.() -> Unit) = startExperiment(StartExperimentRequest.Builder().apply(block).build())

    /**
     * Stops the specified experiment.
     */
    suspend fun stopExperiment(input: StopExperimentRequest): StopExperimentResponse

    /**
     * Stops the specified experiment.
     */
    suspend fun stopExperiment(block: StopExperimentRequest.Builder.() -> Unit) = stopExperiment(StopExperimentRequest.Builder().apply(block).build())

    /**
     * Applies the specified tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies the specified tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the specified experiment template.
     */
    suspend fun updateExperimentTemplate(input: UpdateExperimentTemplateRequest): UpdateExperimentTemplateResponse

    /**
     * Updates the specified experiment template.
     */
    suspend fun updateExperimentTemplate(block: UpdateExperimentTemplateRequest.Builder.() -> Unit) = updateExperimentTemplate(UpdateExperimentTemplateRequest.Builder().apply(block).build())
}
