// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.serde

import aws.sdk.kotlin.services.firehose.model.FirehoseException
import aws.sdk.kotlin.services.firehose.model.PutRecordBatchResponse
import aws.sdk.kotlin.services.firehose.model.PutRecordBatchResponseEntry
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutRecordBatchOperationDeserializer: HttpDeserializer.NonStreaming<PutRecordBatchResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutRecordBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRecordBatchError(context, call, payload)
        }
        val builder = PutRecordBatchResponse.Builder()

        if (payload != null) {
            deserializePutRecordBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutRecordBatchError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FirehoseException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKMSResourceException" -> InvalidKmsResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSourceException" -> InvalidSourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> FirehoseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutRecordBatchOperationBody(builder: PutRecordBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Encrypted"))
    val FAILEDPUTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailedPutCount"))
    val REQUESTRESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RequestResponses"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENCRYPTED_DESCRIPTOR)
        field(FAILEDPUTCOUNT_DESCRIPTOR)
        field(REQUESTRESPONSES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENCRYPTED_DESCRIPTOR.index -> builder.encrypted = deserializeBoolean()
                FAILEDPUTCOUNT_DESCRIPTOR.index -> builder.failedPutCount = deserializeInt()
                REQUESTRESPONSES_DESCRIPTOR.index -> builder.requestResponses =
                    deserializer.deserializeList(REQUESTRESPONSES_DESCRIPTOR) {
                        val col0 = mutableListOf<PutRecordBatchResponseEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePutRecordBatchResponseEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
