// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configure Snowflake destination
 */
public class SnowflakeDestinationConfiguration private constructor(builder: Builder) {
    /**
     * URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier). Note that the protocol (https://) and port number are optional.
     */
    public val accountUrl: kotlin.String = requireNotNull(builder.accountUrl) { "A non-null value must be provided for accountUrl" }
    /**
     * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any value, Firehose uses the default values.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your Firehose stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The name of the record content column.
     */
    public val contentColumnName: kotlin.String? = builder.contentColumnName
    /**
     * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
     */
    public val dataLoadingOption: aws.sdk.kotlin.services.firehose.model.SnowflakeDataLoadingOption? = builder.dataLoadingOption
    /**
     * All data in Snowflake is maintained in databases.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
     */
    public val keyPassphrase: kotlin.String? = builder.keyPassphrase
    /**
     * Specify a column name in the table, where the metadata information has to be loaded. When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.
     *
     * For Direct PUT as source
     *
     * `{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }`
     *
     * For Kinesis Data Stream as source
     *
     * ` "kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }`
     */
    public val metaDataColumnName: kotlin.String? = builder.metaDataColumnName
    /**
     * The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
     */
    public val privateKey: kotlin.String? = builder.privateKey
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the Snowflake role
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * Choose an S3 backup mode
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.SnowflakeS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
     */
    public val schema: kotlin.String = requireNotNull(builder.schema) { "A non-null value must be provided for schema" }
    /**
     * The configuration that defines how you access secrets for Snowflake.
     */
    public val secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = builder.secretsManagerConfiguration
    /**
     * Optionally configure a Snowflake role. Otherwise the default user role will be used.
     */
    public val snowflakeRoleConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration? = builder.snowflakeRoleConfiguration
    /**
     * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.&#91;region&#93;.vpce-svc-<&#91;id&#93;>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
     */
    public val snowflakeVpcConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeVpcConfiguration? = builder.snowflakeVpcConfiguration
    /**
     * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
     */
    public val table: kotlin.String = requireNotNull(builder.table) { "A non-null value must be provided for table" }
    /**
     * User login name for the Snowflake account.
     */
    public val user: kotlin.String? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeDestinationConfiguration(")
        append("accountUrl=*** Sensitive Data Redacted ***,")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("contentColumnName=*** Sensitive Data Redacted ***,")
        append("dataLoadingOption=$dataLoadingOption,")
        append("database=*** Sensitive Data Redacted ***,")
        append("keyPassphrase=*** Sensitive Data Redacted ***,")
        append("metaDataColumnName=*** Sensitive Data Redacted ***,")
        append("privateKey=*** Sensitive Data Redacted ***,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("schema=*** Sensitive Data Redacted ***,")
        append("secretsManagerConfiguration=$secretsManagerConfiguration,")
        append("snowflakeRoleConfiguration=$snowflakeRoleConfiguration,")
        append("snowflakeVpcConfiguration=$snowflakeVpcConfiguration,")
        append("table=*** Sensitive Data Redacted ***,")
        append("user=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountUrl.hashCode()
        result = 31 * result + (bufferingHints?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (contentColumnName?.hashCode() ?: 0)
        result = 31 * result + (dataLoadingOption?.hashCode() ?: 0)
        result = 31 * result + (database.hashCode())
        result = 31 * result + (keyPassphrase?.hashCode() ?: 0)
        result = 31 * result + (metaDataColumnName?.hashCode() ?: 0)
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (schema.hashCode())
        result = 31 * result + (secretsManagerConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snowflakeRoleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snowflakeVpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (table.hashCode())
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeDestinationConfiguration

        if (accountUrl != other.accountUrl) return false
        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (contentColumnName != other.contentColumnName) return false
        if (dataLoadingOption != other.dataLoadingOption) return false
        if (database != other.database) return false
        if (keyPassphrase != other.keyPassphrase) return false
        if (metaDataColumnName != other.metaDataColumnName) return false
        if (privateKey != other.privateKey) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (schema != other.schema) return false
        if (secretsManagerConfiguration != other.secretsManagerConfiguration) return false
        if (snowflakeRoleConfiguration != other.snowflakeRoleConfiguration) return false
        if (snowflakeVpcConfiguration != other.snowflakeVpcConfiguration) return false
        if (table != other.table) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier). Note that the protocol (https://) and port number are optional.
         */
        public var accountUrl: kotlin.String? = null
        /**
         * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any value, Firehose uses the default values.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your Firehose stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The name of the record content column.
         */
        public var contentColumnName: kotlin.String? = null
        /**
         * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
         */
        public var dataLoadingOption: aws.sdk.kotlin.services.firehose.model.SnowflakeDataLoadingOption? = null
        /**
         * All data in Snowflake is maintained in databases.
         */
        public var database: kotlin.String? = null
        /**
         * Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
         */
        public var keyPassphrase: kotlin.String? = null
        /**
         * Specify a column name in the table, where the metadata information has to be loaded. When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.
         *
         * For Direct PUT as source
         *
         * `{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }`
         *
         * For Kinesis Data Stream as source
         *
         * ` "kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }`
         */
        public var metaDataColumnName: kotlin.String? = null
        /**
         * The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
         */
        public var privateKey: kotlin.String? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the Snowflake role
         */
        public var roleArn: kotlin.String? = null
        /**
         * Choose an S3 backup mode
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.SnowflakeS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
         */
        public var schema: kotlin.String? = null
        /**
         * The configuration that defines how you access secrets for Snowflake.
         */
        public var secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = null
        /**
         * Optionally configure a Snowflake role. Otherwise the default user role will be used.
         */
        public var snowflakeRoleConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration? = null
        /**
         * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.&#91;region&#93;.vpce-svc-<&#91;id&#93;>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
         */
        public var snowflakeVpcConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeVpcConfiguration? = null
        /**
         * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
         */
        public var table: kotlin.String? = null
        /**
         * User login name for the Snowflake account.
         */
        public var user: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationConfiguration) : this() {
            this.accountUrl = x.accountUrl
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.contentColumnName = x.contentColumnName
            this.dataLoadingOption = x.dataLoadingOption
            this.database = x.database
            this.keyPassphrase = x.keyPassphrase
            this.metaDataColumnName = x.metaDataColumnName
            this.privateKey = x.privateKey
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.schema = x.schema
            this.secretsManagerConfiguration = x.secretsManagerConfiguration
            this.snowflakeRoleConfiguration = x.snowflakeRoleConfiguration
            this.snowflakeVpcConfiguration = x.snowflakeVpcConfiguration
            this.table = x.table
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationConfiguration = SnowflakeDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration] inside the given [block]
         */
        public fun secretsManagerConfiguration(block: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.Builder.() -> kotlin.Unit) {
            this.secretsManagerConfiguration = aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration] inside the given [block]
         */
        public fun snowflakeRoleConfiguration(block: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration.Builder.() -> kotlin.Unit) {
            this.snowflakeRoleConfiguration = aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeVpcConfiguration] inside the given [block]
         */
        public fun snowflakeVpcConfiguration(block: aws.sdk.kotlin.services.firehose.model.SnowflakeVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.snowflakeVpcConfiguration = aws.sdk.kotlin.services.firehose.model.SnowflakeVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountUrl == null) accountUrl = ""
            if (database == null) database = ""
            if (roleArn == null) roleArn = ""
            if (schema == null) schema = ""
            if (table == null) table = ""
            return this
        }
    }
}
