// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents how to produce partition data for a table. Partition data is produced by transforming columns in a table. Each column transform is represented by a named `PartitionField`.
 *
 * Here is an example of the schema in JSON.
 *
 * `"partitionSpec": { "identity": [ {"sourceName": "column1"}, {"sourceName": "column2"}, {"sourceName": "column3"} ] }`
 *
 * Amazon Data Firehose is in preview release and is subject to change.
 */
public class PartitionSpec private constructor(builder: Builder) {
    /**
     * List of identity [transforms](https://iceberg.apache.org/spec/#partition-transforms) that performs an identity transformation. The transform takes the source value, and does not modify it. Result type is the source type.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val identity: List<PartitionField>? = builder.identity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.PartitionSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PartitionSpec(")
        append("identity=$identity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identity?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PartitionSpec

        if (identity != other.identity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.PartitionSpec = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of identity [transforms](https://iceberg.apache.org/spec/#partition-transforms) that performs an identity transformation. The transform takes the source value, and does not modify it. Result type is the source type.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var identity: List<PartitionField>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.PartitionSpec) : this() {
            this.identity = x.identity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.PartitionSpec = PartitionSpec(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
