// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an update for a destination in Apache Iceberg Tables.
 */
public class IcebergDestinationUpdate private constructor(builder: Builder) {
    /**
     * Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.
     *
     * The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
     */
    public val appendOnly: kotlin.Boolean? = builder.appendOnly
    /**
     * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Firehose might choose to use different values when it is optimal. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = builder.bufferingHints
    /**
     * Configuration describing where the destination Iceberg tables are persisted.
     */
    public val catalogConfiguration: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration? = builder.catalogConfiguration
    /**
     * Describes the Amazon CloudWatch logging options for your Firehose stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
     */
    public val destinationTableConfigurationList: List<DestinationTableConfiguration>? = builder.destinationTableConfigurationList
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Firehose is unable to deliver data to a destination.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.RetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes how Firehose will backup records. Currently,Firehose only supports `FailedDataOnly`.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.IcebergS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The configuration to enable automatic schema evolution.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val schemaEvolutionConfiguration: aws.sdk.kotlin.services.firehose.model.SchemaEvolutionConfiguration? = builder.schemaEvolutionConfiguration
    /**
     * The configuration to enable automatic table creation.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val tableCreationConfiguration: aws.sdk.kotlin.services.firehose.model.TableCreationConfiguration? = builder.tableCreationConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IcebergDestinationUpdate(")
        append("appendOnly=$appendOnly,")
        append("bufferingHints=$bufferingHints,")
        append("catalogConfiguration=$catalogConfiguration,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("destinationTableConfigurationList=$destinationTableConfigurationList,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("schemaEvolutionConfiguration=$schemaEvolutionConfiguration,")
        append("tableCreationConfiguration=$tableCreationConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appendOnly?.hashCode() ?: 0
        result = 31 * result + (bufferingHints?.hashCode() ?: 0)
        result = 31 * result + (catalogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (destinationTableConfigurationList?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (schemaEvolutionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tableCreationConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IcebergDestinationUpdate

        if (appendOnly != other.appendOnly) return false
        if (bufferingHints != other.bufferingHints) return false
        if (catalogConfiguration != other.catalogConfiguration) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (destinationTableConfigurationList != other.destinationTableConfigurationList) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (schemaEvolutionConfiguration != other.schemaEvolutionConfiguration) return false
        if (tableCreationConfiguration != other.tableCreationConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.
         *
         * The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
         */
        public var appendOnly: kotlin.Boolean? = null
        /**
         * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Firehose might choose to use different values when it is optimal. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = null
        /**
         * Configuration describing where the destination Iceberg tables are persisted.
         */
        public var catalogConfiguration: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration? = null
        /**
         * Describes the Amazon CloudWatch logging options for your Firehose stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
         */
        public var destinationTableConfigurationList: List<DestinationTableConfiguration>? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Firehose is unable to deliver data to a destination.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.RetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes how Firehose will backup records. Currently,Firehose only supports `FailedDataOnly`.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.IcebergS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The configuration to enable automatic schema evolution.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var schemaEvolutionConfiguration: aws.sdk.kotlin.services.firehose.model.SchemaEvolutionConfiguration? = null
        /**
         * The configuration to enable automatic table creation.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var tableCreationConfiguration: aws.sdk.kotlin.services.firehose.model.TableCreationConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate) : this() {
            this.appendOnly = x.appendOnly
            this.bufferingHints = x.bufferingHints
            this.catalogConfiguration = x.catalogConfiguration
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.destinationTableConfigurationList = x.destinationTableConfigurationList
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.schemaEvolutionConfiguration = x.schemaEvolutionConfiguration
            this.tableCreationConfiguration = x.tableCreationConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = IcebergDestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.BufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.BufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.BufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CatalogConfiguration] inside the given [block]
         */
        public fun catalogConfiguration(block: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration.Builder.() -> kotlin.Unit) {
            this.catalogConfiguration = aws.sdk.kotlin.services.firehose.model.CatalogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.RetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.RetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.RetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SchemaEvolutionConfiguration] inside the given [block]
         */
        public fun schemaEvolutionConfiguration(block: aws.sdk.kotlin.services.firehose.model.SchemaEvolutionConfiguration.Builder.() -> kotlin.Unit) {
            this.schemaEvolutionConfiguration = aws.sdk.kotlin.services.firehose.model.SchemaEvolutionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.TableCreationConfiguration] inside the given [block]
         */
        public fun tableCreationConfiguration(block: aws.sdk.kotlin.services.firehose.model.TableCreationConfiguration.Builder.() -> kotlin.Unit) {
            this.tableCreationConfiguration = aws.sdk.kotlin.services.firehose.model.TableCreationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
