// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers data.
 */
public class HttpEndpointConfiguration private constructor(builder: Builder) {
    /**
     * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     */
    public val accessKey: kotlin.String? = builder.accessKey
    /**
     * The name of the HTTP endpoint selected as the destination.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The URL of the HTTP endpoint selected as the destination.
     *
     * If you choose an HTTP endpoint as your destination, review and follow the instructions in the [Appendix - HTTP Endpoint Delivery Request and Response Specifications](https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html).
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointConfiguration(")
        append("accessKey=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("url=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKey?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (url.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointConfiguration

        if (accessKey != other.accessKey) return false
        if (name != other.name) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
         */
        public var accessKey: kotlin.String? = null
        /**
         * The name of the HTTP endpoint selected as the destination.
         */
        public var name: kotlin.String? = null
        /**
         * The URL of the HTTP endpoint selected as the destination.
         *
         * If you choose an HTTP endpoint as your destination, review and follow the instructions in the [Appendix - HTTP Endpoint Delivery Request and Response Specifications](https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html).
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration) : this() {
            this.accessKey = x.accessKey
            this.name = x.name
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = HttpEndpointConfiguration(this)

        internal fun correctErrors(): Builder {
            if (url == null) url = ""
            return this
        }
    }
}
