// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure that describes the snapshot information of a table in source database endpoint that Firehose reads.
 *
 * Amazon Data Firehose is in preview release and is subject to change.
 */
public class DatabaseSnapshotInfo private constructor(builder: Builder) {
    /**
     * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
     */
    public val failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = builder.failureDescription
    /**
     * The identifier of the current snapshot of the table in source database endpoint.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The timestamp when the current snapshot is taken on the table.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val requestTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.requestTimestamp) { "A non-null value must be provided for requestTimestamp" }
    /**
     * The principal that sent the request to take the current snapshot on the table.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val requestedBy: aws.sdk.kotlin.services.firehose.model.SnapshotRequestedBy = requireNotNull(builder.requestedBy) { "A non-null value must be provided for requestedBy" }
    /**
     * The status of the current snapshot of the table.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val status: aws.sdk.kotlin.services.firehose.model.SnapshotStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The fully qualified name of the table in source database endpoint that Firehose reads.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val table: kotlin.String = requireNotNull(builder.table) { "A non-null value must be provided for table" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DatabaseSnapshotInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatabaseSnapshotInfo(")
        append("failureDescription=$failureDescription,")
        append("id=$id,")
        append("requestTimestamp=$requestTimestamp,")
        append("requestedBy=$requestedBy,")
        append("status=$status,")
        append("table=$table")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureDescription?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (requestTimestamp.hashCode())
        result = 31 * result + (requestedBy.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (table.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatabaseSnapshotInfo

        if (failureDescription != other.failureDescription) return false
        if (id != other.id) return false
        if (requestTimestamp != other.requestTimestamp) return false
        if (requestedBy != other.requestedBy) return false
        if (status != other.status) return false
        if (table != other.table) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DatabaseSnapshotInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
         */
        public var failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = null
        /**
         * The identifier of the current snapshot of the table in source database endpoint.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp when the current snapshot is taken on the table.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var requestTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The principal that sent the request to take the current snapshot on the table.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var requestedBy: aws.sdk.kotlin.services.firehose.model.SnapshotRequestedBy? = null
        /**
         * The status of the current snapshot of the table.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var status: aws.sdk.kotlin.services.firehose.model.SnapshotStatus? = null
        /**
         * The fully qualified name of the table in source database endpoint that Firehose reads.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var table: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DatabaseSnapshotInfo) : this() {
            this.failureDescription = x.failureDescription
            this.id = x.id
            this.requestTimestamp = x.requestTimestamp
            this.requestedBy = x.requestedBy
            this.status = x.status
            this.table = x.table
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DatabaseSnapshotInfo = DatabaseSnapshotInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.FailureDescription] inside the given [block]
         */
        public fun failureDescription(block: aws.sdk.kotlin.services.firehose.model.FailureDescription.Builder.() -> kotlin.Unit) {
            this.failureDescription = aws.sdk.kotlin.services.firehose.model.FailureDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (requestTimestamp == null) requestTimestamp = Instant.fromEpochSeconds(0)
            if (requestedBy == null) requestedBy = SnapshotRequestedBy.SdkUnknown("no value provided")
            if (status == null) status = SnapshotStatus.SdkUnknown("no value provided")
            if (table == null) table = ""
            return this
        }
    }
}
