// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of a destination in Amazon OpenSearch Service
 */
public class AmazonopensearchserviceDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your Firehose stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN field.
     */
    public val clusterEndpoint: kotlin.String? = builder.clusterEndpoint
    /**
     * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
     */
    public val documentIdOptions: aws.sdk.kotlin.services.firehose.model.DocumentIdOptions? = builder.documentIdOptions
    /**
     * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeElasticsearchDomain, DescribeElasticsearchDomains, and DescribeElasticsearchDomainConfig after assuming the role specified in RoleARN.
     */
    public val domainArn: kotlin.String? = builder.domainArn
    /**
     * The ElasticsearAmazon OpenSearch Service index name.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
     */
    public val indexRotationPeriod: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceIndexRotationPeriod? = builder.indexRotationPeriod
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default value is 300 (5 minutes).
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a new type for an existing index that already has another type, Firehose returns an error during run time.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * The details of the VPC of the Amazon OpenSearch or Amazon OpenSearch Serverless destination.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AmazonopensearchserviceDestinationConfiguration(")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("clusterEndpoint=$clusterEndpoint,")
        append("documentIdOptions=$documentIdOptions,")
        append("domainArn=$domainArn,")
        append("indexName=$indexName,")
        append("indexRotationPeriod=$indexRotationPeriod,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("typeName=$typeName,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (clusterEndpoint?.hashCode() ?: 0)
        result = 31 * result + (documentIdOptions?.hashCode() ?: 0)
        result = 31 * result + (domainArn?.hashCode() ?: 0)
        result = 31 * result + (indexName.hashCode())
        result = 31 * result + (indexRotationPeriod?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AmazonopensearchserviceDestinationConfiguration

        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (clusterEndpoint != other.clusterEndpoint) return false
        if (documentIdOptions != other.documentIdOptions) return false
        if (domainArn != other.domainArn) return false
        if (indexName != other.indexName) return false
        if (indexRotationPeriod != other.indexRotationPeriod) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (typeName != other.typeName) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceDestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your Firehose stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN field.
         */
        public var clusterEndpoint: kotlin.String? = null
        /**
         * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
         */
        public var documentIdOptions: aws.sdk.kotlin.services.firehose.model.DocumentIdOptions? = null
        /**
         * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeElasticsearchDomain, DescribeElasticsearchDomains, and DescribeElasticsearchDomainConfig after assuming the role specified in RoleARN.
         */
        public var domainArn: kotlin.String? = null
        /**
         * The ElasticsearAmazon OpenSearch Service index name.
         */
        public var indexName: kotlin.String? = null
        /**
         * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
         */
        public var indexRotationPeriod: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceIndexRotationPeriod? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default value is 300 (5 minutes).
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a new type for an existing index that already has another type, Firehose returns an error during run time.
         */
        public var typeName: kotlin.String? = null
        /**
         * The details of the VPC of the Amazon OpenSearch or Amazon OpenSearch Serverless destination.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceDestinationConfiguration) : this() {
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.clusterEndpoint = x.clusterEndpoint
            this.documentIdOptions = x.documentIdOptions
            this.domainArn = x.domainArn
            this.indexName = x.indexName
            this.indexRotationPeriod = x.indexRotationPeriod
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.typeName = x.typeName
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceDestinationConfiguration = AmazonopensearchserviceDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DocumentIdOptions] inside the given [block]
         */
        public fun documentIdOptions(block: aws.sdk.kotlin.services.firehose.model.DocumentIdOptions.Builder.() -> kotlin.Unit) {
            this.documentIdOptions = aws.sdk.kotlin.services.firehose.model.DocumentIdOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.AmazonopensearchserviceRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.firehose.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.firehose.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
