// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.serde

import aws.sdk.kotlin.services.firehose.model.FirehoseException
import aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListDeliveryStreamsOperationDeserializer: HttpDeserializer.NonStreaming<ListDeliveryStreamsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListDeliveryStreamsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListDeliveryStreamsError(context, call, payload)
        }
        val builder = ListDeliveryStreamsResponse.Builder()

        if (payload != null) {
            deserializeListDeliveryStreamsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListDeliveryStreamsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FirehoseException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> FirehoseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDeliveryStreamsOperationBody(builder: ListDeliveryStreamsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERYSTREAMNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeliveryStreamNames"))
    val HASMOREDELIVERYSTREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HasMoreDeliveryStreams"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERYSTREAMNAMES_DESCRIPTOR)
        field(HASMOREDELIVERYSTREAMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERYSTREAMNAMES_DESCRIPTOR.index -> builder.deliveryStreamNames =
                    deserializer.deserializeList(DELIVERYSTREAMNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HASMOREDELIVERYSTREAMS_DESCRIPTOR.index -> builder.hasMoreDeliveryStreams = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
