// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about a Kinesis data stream used as the source for a Firehose stream.
 */
public class SourceDescription private constructor(builder: Builder) {
    /**
     * Details about a database used as the source for a Firehose stream.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val databaseSourceDescription: aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription? = builder.databaseSourceDescription
    /**
     * Details about Direct PUT used as the source for a Firehose stream.
     */
    public val directPutSourceDescription: aws.sdk.kotlin.services.firehose.model.DirectPutSourceDescription? = builder.directPutSourceDescription
    /**
     * The KinesisStreamSourceDescription value for the source Kinesis data stream.
     */
    public val kinesisStreamSourceDescription: aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription? = builder.kinesisStreamSourceDescription
    /**
     * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    public val mskSourceDescription: aws.sdk.kotlin.services.firehose.model.MskSourceDescription? = builder.mskSourceDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceDescription(")
        append("databaseSourceDescription=$databaseSourceDescription,")
        append("directPutSourceDescription=$directPutSourceDescription,")
        append("kinesisStreamSourceDescription=$kinesisStreamSourceDescription,")
        append("mskSourceDescription=$mskSourceDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseSourceDescription?.hashCode() ?: 0
        result = 31 * result + (directPutSourceDescription?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamSourceDescription?.hashCode() ?: 0)
        result = 31 * result + (mskSourceDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceDescription

        if (databaseSourceDescription != other.databaseSourceDescription) return false
        if (directPutSourceDescription != other.directPutSourceDescription) return false
        if (kinesisStreamSourceDescription != other.kinesisStreamSourceDescription) return false
        if (mskSourceDescription != other.mskSourceDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SourceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Details about a database used as the source for a Firehose stream.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var databaseSourceDescription: aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription? = null
        /**
         * Details about Direct PUT used as the source for a Firehose stream.
         */
        public var directPutSourceDescription: aws.sdk.kotlin.services.firehose.model.DirectPutSourceDescription? = null
        /**
         * The KinesisStreamSourceDescription value for the source Kinesis data stream.
         */
        public var kinesisStreamSourceDescription: aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription? = null
        /**
         * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
         */
        public var mskSourceDescription: aws.sdk.kotlin.services.firehose.model.MskSourceDescription? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SourceDescription) : this() {
            this.databaseSourceDescription = x.databaseSourceDescription
            this.directPutSourceDescription = x.directPutSourceDescription
            this.kinesisStreamSourceDescription = x.kinesisStreamSourceDescription
            this.mskSourceDescription = x.mskSourceDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SourceDescription = SourceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription] inside the given [block]
         */
        public fun databaseSourceDescription(block: aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription.Builder.() -> kotlin.Unit) {
            this.databaseSourceDescription = aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DirectPutSourceDescription] inside the given [block]
         */
        public fun directPutSourceDescription(block: aws.sdk.kotlin.services.firehose.model.DirectPutSourceDescription.Builder.() -> kotlin.Unit) {
            this.directPutSourceDescription = aws.sdk.kotlin.services.firehose.model.DirectPutSourceDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription] inside the given [block]
         */
        public fun kinesisStreamSourceDescription(block: aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription.Builder.() -> kotlin.Unit) {
            this.kinesisStreamSourceDescription = aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.MskSourceDescription] inside the given [block]
         */
        public fun mskSourceDescription(block: aws.sdk.kotlin.services.firehose.model.MskSourceDescription.Builder.() -> kotlin.Unit) {
            this.mskSourceDescription = aws.sdk.kotlin.services.firehose.model.MskSourceDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
