// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specify how long Firehose retries sending data to the New Relic HTTP endpoint. After sending data, Firehose first waits for an acknowledgment from the HTTP endpoint. If an error occurs or the acknowledgment doesn’t arrive within the acknowledgment timeout period, Firehose starts the retry duration counter. It keeps retrying until the retry duration expires. After that, Firehose considers it a data delivery failure and backs up the data to your Amazon S3 bucket. Every time that Firehose sends data to the HTTP endpoint (either the initial attempt or a retry), it restarts the acknowledgement timeout counter and waits for an acknowledgement from the HTTP endpoint. Even if the retry duration expires, Firehose still waits for the acknowledgment until it receives it or the acknowledgement timeout period is reached. If the acknowledgment times out, Firehose determines whether there's time left in the retry counter. If there is time left, it retries again and repeats the logic until it receives an acknowledgment or determines that the retry time has expired. If you don't want Firehose to retry sending data, set this value to 0.
 */
public class SnowflakeRetryOptions private constructor(builder: Builder) {
    /**
     * the time period where Firehose will retry sending data to the chosen HTTP endpoint.
     */
    public val durationInSeconds: kotlin.Int? = builder.durationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeRetryOptions(")
        append("durationInSeconds=$durationInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeRetryOptions

        if (durationInSeconds != other.durationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * the time period where Firehose will retry sending data to the chosen HTTP endpoint.
         */
        public var durationInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions) : this() {
            this.durationInSeconds = x.durationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions = SnowflakeRetryOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
