// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any value, Firehose uses the default values.
 */
public class SnowflakeBufferingHints private constructor(builder: Builder) {
    /**
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 0.
     */
    public val intervalInSeconds: kotlin.Int? = builder.intervalInSeconds
    /**
     * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 128.
     */
    public val sizeInMbs: kotlin.Int? = builder.sizeInMbs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeBufferingHints(")
        append("intervalInSeconds=$intervalInSeconds,")
        append("sizeInMbs=$sizeInMbs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intervalInSeconds ?: 0
        result = 31 * result + (sizeInMbs ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeBufferingHints

        if (intervalInSeconds != other.intervalInSeconds) return false
        if (sizeInMbs != other.sizeInMbs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 0.
         */
        public var intervalInSeconds: kotlin.Int? = null
        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 128.
         */
        public var sizeInMbs: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints) : this() {
            this.intervalInSeconds = x.intervalInSeconds
            this.sizeInMbs = x.sizeInMbs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints = SnowflakeBufferingHints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
