// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a Firehose stream.
 */
public class KinesisStreamSourceConfiguration private constructor(builder: Builder) {
    /**
     * The ARN of the source Kinesis data stream. For more information, see [Amazon Kinesis Data Streams ARN Format](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
     */
    public val kinesisStreamArn: kotlin.String = requireNotNull(builder.kinesisStreamArn) { "A non-null value must be provided for kinesisStreamArn" }
    /**
     * The ARN of the role that provides access to the source Kinesis data stream. For more information, see [Amazon Web Services Identity and Access Management (IAM) ARN Format](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamSourceConfiguration(")
        append("kinesisStreamArn=$kinesisStreamArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kinesisStreamArn.hashCode()
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisStreamSourceConfiguration

        if (kinesisStreamArn != other.kinesisStreamArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the source Kinesis data stream. For more information, see [Amazon Kinesis Data Streams ARN Format](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
         */
        public var kinesisStreamArn: kotlin.String? = null
        /**
         * The ARN of the role that provides access to the source Kinesis data stream. For more information, see [Amazon Web Services Identity and Access Management (IAM) ARN Format](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceConfiguration) : this() {
            this.kinesisStreamArn = x.kinesisStreamArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceConfiguration = KinesisStreamSourceConfiguration(this)

        internal fun correctErrors(): Builder {
            if (kinesisStreamArn == null) kinesisStreamArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
