// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
 */
public class HttpEndpointRetryOptions private constructor(builder: Builder) {
    /**
     * The total amount of time that Firehose spends on retries. This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Firehose waits for acknowledgment from the specified destination after each attempt.
     */
    public val durationInSeconds: kotlin.Int? = builder.durationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointRetryOptions(")
        append("durationInSeconds=$durationInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointRetryOptions

        if (durationInSeconds != other.durationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total amount of time that Firehose spends on retries. This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Firehose waits for acknowledgment from the specified destination after each attempt.
         */
        public var durationInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions) : this() {
            this.durationInSeconds = x.durationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions = HttpEndpointRetryOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
