// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of the HTTP endpoint destination.
 */
public class HttpEndpointDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The buffering options that can be used before data is delivered to the specified destination. Firehose treats these options as hints, and it might choose to use more optimal values. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your Firehose stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The configuration of the HTTP endpoint selected as the destination.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration? = builder.endpointConfiguration
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The configuration of the request sent to the HTTP endpoint that is specified as the destination.
     */
    public val requestConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration? = builder.requestConfiguration
    /**
     * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions? = builder.retryOptions
    /**
     * Firehose uses this IAM role for all the permissions that the delivery stream needs.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the S3 bucket backup options for the data that Firehose delivers to the HTTP endpoint destination. You can back up all documents (`AllData`) or only the documents that Firehose could not deliver to the specified HTTP endpoint destination (`FailedDataOnly`).
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.HttpEndpointS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The configuration that defines how you access secrets for HTTP Endpoint destination.
     */
    public val secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = builder.secretsManagerConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointDestinationConfiguration(")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("processingConfiguration=$processingConfiguration,")
        append("requestConfiguration=$requestConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("secretsManagerConfiguration=$secretsManagerConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requestConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointDestinationConfiguration

        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (requestConfiguration != other.requestConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (secretsManagerConfiguration != other.secretsManagerConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The buffering options that can be used before data is delivered to the specified destination. Firehose treats these options as hints, and it might choose to use more optimal values. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your Firehose stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The configuration of the HTTP endpoint selected as the destination.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The configuration of the request sent to the HTTP endpoint that is specified as the destination.
         */
        public var requestConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration? = null
        /**
         * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions? = null
        /**
         * Firehose uses this IAM role for all the permissions that the delivery stream needs.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes the S3 bucket backup options for the data that Firehose delivers to the HTTP endpoint destination. You can back up all documents (`AllData`) or only the documents that Firehose could not deliver to the specified HTTP endpoint destination (`FailedDataOnly`).
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.HttpEndpointS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The configuration that defines how you access secrets for HTTP Endpoint destination.
         */
        public var secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationConfiguration) : this() {
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.endpointConfiguration = x.endpointConfiguration
            this.processingConfiguration = x.processingConfiguration
            this.requestConfiguration = x.requestConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.secretsManagerConfiguration = x.secretsManagerConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationConfiguration = HttpEndpointDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration] inside the given [block]
         */
        public fun requestConfiguration(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration.Builder.() -> kotlin.Unit) {
            this.requestConfiguration = aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration] inside the given [block]
         */
        public fun secretsManagerConfiguration(block: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.Builder.() -> kotlin.Unit) {
            this.secretsManagerConfiguration = aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
