// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The top level object for database source description.
 *
 * Amazon Data Firehose is in preview release and is subject to change.
 */
public class DatabaseSourceDescription private constructor(builder: Builder) {
    /**
     * The list of column patterns in source database endpoint for Firehose to read from.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val columns: aws.sdk.kotlin.services.firehose.model.DatabaseColumnList? = builder.columns
    /**
     * The structure to configure the authentication methods for Firehose to connect to source database endpoint.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val databaseSourceAuthenticationConfiguration: aws.sdk.kotlin.services.firehose.model.DatabaseSourceAuthenticationConfiguration? = builder.databaseSourceAuthenticationConfiguration
    /**
     * The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val databaseSourceVpcConfiguration: aws.sdk.kotlin.services.firehose.model.DatabaseSourceVpcConfiguration? = builder.databaseSourceVpcConfiguration
    /**
     * The list of database patterns in source database endpoint for Firehose to read from.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val databases: aws.sdk.kotlin.services.firehose.model.DatabaseList? = builder.databases
    /**
     * The endpoint of the database server.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The port of the database. This can be one of the following values.
     * + 3306 for MySQL database type
     * + 5432 for PostgreSQL database type
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The structure that describes the snapshot information of a table in source database endpoint that Firehose reads.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val snapshotInfo: List<DatabaseSnapshotInfo>? = builder.snapshotInfo
    /**
     * The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val snapshotWatermarkTable: kotlin.String? = builder.snapshotWatermarkTable
    /**
     * The mode to enable or disable SSL when Firehose connects to the database endpoint.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val sslMode: aws.sdk.kotlin.services.firehose.model.SslMode? = builder.sslMode
    /**
     * The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val surrogateKeys: List<String>? = builder.surrogateKeys
    /**
     * The list of table patterns in source database endpoint for Firehose to read from.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val tables: aws.sdk.kotlin.services.firehose.model.DatabaseTableList? = builder.tables
    /**
     * The type of database engine. This can be one of the following values.
     * + MySQL
     * + PostgreSQL
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val type: aws.sdk.kotlin.services.firehose.model.DatabaseType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatabaseSourceDescription(")
        append("columns=$columns,")
        append("databaseSourceAuthenticationConfiguration=$databaseSourceAuthenticationConfiguration,")
        append("databaseSourceVpcConfiguration=$databaseSourceVpcConfiguration,")
        append("databases=$databases,")
        append("endpoint=$endpoint,")
        append("port=$port,")
        append("snapshotInfo=$snapshotInfo,")
        append("snapshotWatermarkTable=$snapshotWatermarkTable,")
        append("sslMode=$sslMode,")
        append("surrogateKeys=$surrogateKeys,")
        append("tables=$tables,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = columns?.hashCode() ?: 0
        result = 31 * result + (databaseSourceAuthenticationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (databaseSourceVpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (databases?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (snapshotInfo?.hashCode() ?: 0)
        result = 31 * result + (snapshotWatermarkTable?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        result = 31 * result + (surrogateKeys?.hashCode() ?: 0)
        result = 31 * result + (tables?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatabaseSourceDescription

        if (columns != other.columns) return false
        if (databaseSourceAuthenticationConfiguration != other.databaseSourceAuthenticationConfiguration) return false
        if (databaseSourceVpcConfiguration != other.databaseSourceVpcConfiguration) return false
        if (databases != other.databases) return false
        if (endpoint != other.endpoint) return false
        if (port != other.port) return false
        if (snapshotInfo != other.snapshotInfo) return false
        if (snapshotWatermarkTable != other.snapshotWatermarkTable) return false
        if (sslMode != other.sslMode) return false
        if (surrogateKeys != other.surrogateKeys) return false
        if (tables != other.tables) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of column patterns in source database endpoint for Firehose to read from.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var columns: aws.sdk.kotlin.services.firehose.model.DatabaseColumnList? = null
        /**
         * The structure to configure the authentication methods for Firehose to connect to source database endpoint.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var databaseSourceAuthenticationConfiguration: aws.sdk.kotlin.services.firehose.model.DatabaseSourceAuthenticationConfiguration? = null
        /**
         * The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var databaseSourceVpcConfiguration: aws.sdk.kotlin.services.firehose.model.DatabaseSourceVpcConfiguration? = null
        /**
         * The list of database patterns in source database endpoint for Firehose to read from.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var databases: aws.sdk.kotlin.services.firehose.model.DatabaseList? = null
        /**
         * The endpoint of the database server.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The port of the database. This can be one of the following values.
         * + 3306 for MySQL database type
         * + 5432 for PostgreSQL database type
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var port: kotlin.Int? = null
        /**
         * The structure that describes the snapshot information of a table in source database endpoint that Firehose reads.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var snapshotInfo: List<DatabaseSnapshotInfo>? = null
        /**
         * The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var snapshotWatermarkTable: kotlin.String? = null
        /**
         * The mode to enable or disable SSL when Firehose connects to the database endpoint.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var sslMode: aws.sdk.kotlin.services.firehose.model.SslMode? = null
        /**
         * The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var surrogateKeys: List<String>? = null
        /**
         * The list of table patterns in source database endpoint for Firehose to read from.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var tables: aws.sdk.kotlin.services.firehose.model.DatabaseTableList? = null
        /**
         * The type of database engine. This can be one of the following values.
         * + MySQL
         * + PostgreSQL
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var type: aws.sdk.kotlin.services.firehose.model.DatabaseType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription) : this() {
            this.columns = x.columns
            this.databaseSourceAuthenticationConfiguration = x.databaseSourceAuthenticationConfiguration
            this.databaseSourceVpcConfiguration = x.databaseSourceVpcConfiguration
            this.databases = x.databases
            this.endpoint = x.endpoint
            this.port = x.port
            this.snapshotInfo = x.snapshotInfo
            this.snapshotWatermarkTable = x.snapshotWatermarkTable
            this.sslMode = x.sslMode
            this.surrogateKeys = x.surrogateKeys
            this.tables = x.tables
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DatabaseSourceDescription = DatabaseSourceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseColumnList] inside the given [block]
         */
        public fun columns(block: aws.sdk.kotlin.services.firehose.model.DatabaseColumnList.Builder.() -> kotlin.Unit) {
            this.columns = aws.sdk.kotlin.services.firehose.model.DatabaseColumnList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseSourceAuthenticationConfiguration] inside the given [block]
         */
        public fun databaseSourceAuthenticationConfiguration(block: aws.sdk.kotlin.services.firehose.model.DatabaseSourceAuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.databaseSourceAuthenticationConfiguration = aws.sdk.kotlin.services.firehose.model.DatabaseSourceAuthenticationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseSourceVpcConfiguration] inside the given [block]
         */
        public fun databaseSourceVpcConfiguration(block: aws.sdk.kotlin.services.firehose.model.DatabaseSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.databaseSourceVpcConfiguration = aws.sdk.kotlin.services.firehose.model.DatabaseSourceVpcConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseList] inside the given [block]
         */
        public fun databases(block: aws.sdk.kotlin.services.firehose.model.DatabaseList.Builder.() -> kotlin.Unit) {
            this.databases = aws.sdk.kotlin.services.firehose.model.DatabaseList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DatabaseTableList] inside the given [block]
         */
        public fun tables(block: aws.sdk.kotlin.services.firehose.model.DatabaseTableList.Builder.() -> kotlin.Unit) {
            this.tables = aws.sdk.kotlin.services.firehose.model.DatabaseTableList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
