// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Update to configuration settings
 */
public class SnowflakeDestinationUpdate private constructor(builder: Builder) {
    /**
     * URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier). Note that the protocol (https://) and port number are optional.
     */
    public val accountUrl: kotlin.String? = builder.accountUrl
    /**
     * Describes the buffering to perform before delivering data to the Snowflake destination.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The name of the content metadata column
     */
    public val contentColumnName: kotlin.String? = builder.contentColumnName
    /**
     * JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
     */
    public val dataLoadingOption: aws.sdk.kotlin.services.firehose.model.SnowflakeDataLoadingOption? = builder.dataLoadingOption
    /**
     * All data in Snowflake is maintained in databases.
     */
    public val database: kotlin.String? = builder.database
    /**
     * Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
     */
    public val keyPassphrase: kotlin.String? = builder.keyPassphrase
    /**
     * The name of the record metadata column
     */
    public val metaDataColumnName: kotlin.String? = builder.metaDataColumnName
    /**
     * The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
     */
    public val privateKey: kotlin.String? = builder.privateKey
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * Specify how long Firehose retries sending data to the New Relic HTTP endpoint. After sending data, Firehose first waits for an acknowledgment from the HTTP endpoint. If an error occurs or the acknowledgment doesn’t arrive within the acknowledgment timeout period, Firehose starts the retry duration counter. It keeps retrying until the retry duration expires. After that, Firehose considers it a data delivery failure and backs up the data to your Amazon S3 bucket. Every time that Firehose sends data to the HTTP endpoint (either the initial attempt or a retry), it restarts the acknowledgement timeout counter and waits for an acknowledgement from the HTTP endpoint. Even if the retry duration expires, Firehose still waits for the acknowledgment until it receives it or the acknowledgement timeout period is reached. If the acknowledgment times out, Firehose determines whether there's time left in the retry counter. If there is time left, it retries again and repeats the logic until it receives an acknowledgment or determines that the retry time has expired. If you don't want Firehose to retry sending data, set this value to 0.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the Snowflake role
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Choose an S3 backup mode
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.SnowflakeS3BackupMode? = builder.s3BackupMode
    /**
     * Describes an update for a destination in Amazon S3.
     */
    public val s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = builder.s3Update
    /**
     * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
     */
    public val schema: kotlin.String? = builder.schema
    /**
     * Describes the Secrets Manager configuration in Snowflake.
     */
    public val secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = builder.secretsManagerConfiguration
    /**
     * Optionally configure a Snowflake role. Otherwise the default user role will be used.
     */
    public val snowflakeRoleConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration? = builder.snowflakeRoleConfiguration
    /**
     * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
     */
    public val table: kotlin.String? = builder.table
    /**
     * User login name for the Snowflake account.
     */
    public val user: kotlin.String? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeDestinationUpdate(")
        append("accountUrl=*** Sensitive Data Redacted ***,")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("contentColumnName=*** Sensitive Data Redacted ***,")
        append("dataLoadingOption=$dataLoadingOption,")
        append("database=*** Sensitive Data Redacted ***,")
        append("keyPassphrase=*** Sensitive Data Redacted ***,")
        append("metaDataColumnName=*** Sensitive Data Redacted ***,")
        append("privateKey=*** Sensitive Data Redacted ***,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Update=$s3Update,")
        append("schema=*** Sensitive Data Redacted ***,")
        append("secretsManagerConfiguration=$secretsManagerConfiguration,")
        append("snowflakeRoleConfiguration=$snowflakeRoleConfiguration,")
        append("table=*** Sensitive Data Redacted ***,")
        append("user=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountUrl?.hashCode() ?: 0
        result = 31 * result + (bufferingHints?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (contentColumnName?.hashCode() ?: 0)
        result = 31 * result + (dataLoadingOption?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (keyPassphrase?.hashCode() ?: 0)
        result = 31 * result + (metaDataColumnName?.hashCode() ?: 0)
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Update?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snowflakeRoleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (table?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeDestinationUpdate

        if (accountUrl != other.accountUrl) return false
        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (contentColumnName != other.contentColumnName) return false
        if (dataLoadingOption != other.dataLoadingOption) return false
        if (database != other.database) return false
        if (keyPassphrase != other.keyPassphrase) return false
        if (metaDataColumnName != other.metaDataColumnName) return false
        if (privateKey != other.privateKey) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Update != other.s3Update) return false
        if (schema != other.schema) return false
        if (secretsManagerConfiguration != other.secretsManagerConfiguration) return false
        if (snowflakeRoleConfiguration != other.snowflakeRoleConfiguration) return false
        if (table != other.table) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier). Note that the protocol (https://) and port number are optional.
         */
        public var accountUrl: kotlin.String? = null
        /**
         * Describes the buffering to perform before delivering data to the Snowflake destination.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The name of the content metadata column
         */
        public var contentColumnName: kotlin.String? = null
        /**
         * JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
         */
        public var dataLoadingOption: aws.sdk.kotlin.services.firehose.model.SnowflakeDataLoadingOption? = null
        /**
         * All data in Snowflake is maintained in databases.
         */
        public var database: kotlin.String? = null
        /**
         * Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
         */
        public var keyPassphrase: kotlin.String? = null
        /**
         * The name of the record metadata column
         */
        public var metaDataColumnName: kotlin.String? = null
        /**
         * The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation).
         */
        public var privateKey: kotlin.String? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * Specify how long Firehose retries sending data to the New Relic HTTP endpoint. After sending data, Firehose first waits for an acknowledgment from the HTTP endpoint. If an error occurs or the acknowledgment doesn’t arrive within the acknowledgment timeout period, Firehose starts the retry duration counter. It keeps retrying until the retry duration expires. After that, Firehose considers it a data delivery failure and backs up the data to your Amazon S3 bucket. Every time that Firehose sends data to the HTTP endpoint (either the initial attempt or a retry), it restarts the acknowledgement timeout counter and waits for an acknowledgement from the HTTP endpoint. Even if the retry duration expires, Firehose still waits for the acknowledgment until it receives it or the acknowledgement timeout period is reached. If the acknowledgment times out, Firehose determines whether there's time left in the retry counter. If there is time left, it retries again and repeats the logic until it receives an acknowledgment or determines that the retry time has expired. If you don't want Firehose to retry sending data, set this value to 0.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the Snowflake role
         */
        public var roleArn: kotlin.String? = null
        /**
         * Choose an S3 backup mode
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.SnowflakeS3BackupMode? = null
        /**
         * Describes an update for a destination in Amazon S3.
         */
        public var s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = null
        /**
         * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
         */
        public var schema: kotlin.String? = null
        /**
         * Describes the Secrets Manager configuration in Snowflake.
         */
        public var secretsManagerConfiguration: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration? = null
        /**
         * Optionally configure a Snowflake role. Otherwise the default user role will be used.
         */
        public var snowflakeRoleConfiguration: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration? = null
        /**
         * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
         */
        public var table: kotlin.String? = null
        /**
         * User login name for the Snowflake account.
         */
        public var user: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationUpdate) : this() {
            this.accountUrl = x.accountUrl
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.contentColumnName = x.contentColumnName
            this.dataLoadingOption = x.dataLoadingOption
            this.database = x.database
            this.keyPassphrase = x.keyPassphrase
            this.metaDataColumnName = x.metaDataColumnName
            this.privateKey = x.privateKey
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Update = x.s3Update
            this.schema = x.schema
            this.secretsManagerConfiguration = x.secretsManagerConfiguration
            this.snowflakeRoleConfiguration = x.snowflakeRoleConfiguration
            this.table = x.table
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SnowflakeDestinationUpdate = SnowflakeDestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.SnowflakeBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.SnowflakeRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate] inside the given [block]
         */
        public fun s3Update(block: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.Builder.() -> kotlin.Unit) {
            this.s3Update = aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration] inside the given [block]
         */
        public fun secretsManagerConfiguration(block: aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.Builder.() -> kotlin.Unit) {
            this.secretsManagerConfiguration = aws.sdk.kotlin.services.firehose.model.SecretsManagerConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration] inside the given [block]
         */
        public fun snowflakeRoleConfiguration(block: aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration.Builder.() -> kotlin.Unit) {
            this.snowflakeRoleConfiguration = aws.sdk.kotlin.services.firehose.model.SnowflakeRoleConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
