// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
 */
public class MskSourceConfiguration private constructor(builder: Builder) {
    /**
     * The authentication configuration of the Amazon MSK cluster.
     */
    public val authenticationConfiguration: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration? = builder.authenticationConfiguration
    /**
     * The ARN of the Amazon MSK cluster.
     */
    public val mskClusterArn: kotlin.String = requireNotNull(builder.mskClusterArn) { "A non-null value must be provided for mskClusterArn" }
    /**
     * The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read. By default, this is set to timestamp when Firehose becomes Active.
     *
     * If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the `ReadFromTimestamp` parameter to Epoch (1970-01-01T00:00:00Z).
     */
    public val readFromTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.readFromTimestamp
    /**
     * The topic name within the Amazon MSK cluster.
     */
    public val topicName: kotlin.String = requireNotNull(builder.topicName) { "A non-null value must be provided for topicName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.MskSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MskSourceConfiguration(")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("mskClusterArn=$mskClusterArn,")
        append("readFromTimestamp=$readFromTimestamp,")
        append("topicName=$topicName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfiguration?.hashCode() ?: 0
        result = 31 * result + (mskClusterArn.hashCode())
        result = 31 * result + (readFromTimestamp?.hashCode() ?: 0)
        result = 31 * result + (topicName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MskSourceConfiguration

        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (mskClusterArn != other.mskClusterArn) return false
        if (readFromTimestamp != other.readFromTimestamp) return false
        if (topicName != other.topicName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.MskSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication configuration of the Amazon MSK cluster.
         */
        public var authenticationConfiguration: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration? = null
        /**
         * The ARN of the Amazon MSK cluster.
         */
        public var mskClusterArn: kotlin.String? = null
        /**
         * The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read. By default, this is set to timestamp when Firehose becomes Active.
         *
         * If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the `ReadFromTimestamp` parameter to Epoch (1970-01-01T00:00:00Z).
         */
        public var readFromTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The topic name within the Amazon MSK cluster.
         */
        public var topicName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.MskSourceConfiguration) : this() {
            this.authenticationConfiguration = x.authenticationConfiguration
            this.mskClusterArn = x.mskClusterArn
            this.readFromTimestamp = x.readFromTimestamp
            this.topicName = x.topicName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.MskSourceConfiguration = MskSourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration] inside the given [block]
         */
        public fun authenticationConfiguration(block: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.authenticationConfiguration = aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (mskClusterArn == null) mskClusterArn = ""
            if (topicName == null) topicName = ""
            return this
        }
    }
}
