// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an update for a destination in Apache Iceberg Tables.
 *
 * Amazon Data Firehose is in preview release and is subject to change.
 */
public class IcebergDestinationUpdate private constructor(builder: Builder) {
    /**
     * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Firehose might choose to use different values when it is optimal. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = builder.bufferingHints
    /**
     * Configuration describing where the destination Iceberg tables are persisted.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val catalogConfiguration: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration? = builder.catalogConfiguration
    /**
     * Describes the Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg tables.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val destinationTableConfigurationList: List<DestinationTableConfiguration>? = builder.destinationTableConfigurationList
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Firehose is unable to deliver data to an Amazon S3 prefix.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.RetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the Apache Iceberg Tables role.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes how Firehose will backup records. Currently,Firehose only supports `FailedDataOnly` for preview.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.IcebergS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IcebergDestinationUpdate(")
        append("bufferingHints=$bufferingHints,")
        append("catalogConfiguration=$catalogConfiguration,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("destinationTableConfigurationList=$destinationTableConfigurationList,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (catalogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (destinationTableConfigurationList?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IcebergDestinationUpdate

        if (bufferingHints != other.bufferingHints) return false
        if (catalogConfiguration != other.catalogConfiguration) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (destinationTableConfigurationList != other.destinationTableConfigurationList) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Firehose might choose to use different values when it is optimal. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = null
        /**
         * Configuration describing where the destination Iceberg tables are persisted.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var catalogConfiguration: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration? = null
        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg tables.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var destinationTableConfigurationList: List<DestinationTableConfiguration>? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Firehose is unable to deliver data to an Amazon S3 prefix.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.RetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the Apache Iceberg Tables role.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes how Firehose will backup records. Currently,Firehose only supports `FailedDataOnly` for preview.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.IcebergS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate) : this() {
            this.bufferingHints = x.bufferingHints
            this.catalogConfiguration = x.catalogConfiguration
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.destinationTableConfigurationList = x.destinationTableConfigurationList
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.IcebergDestinationUpdate = IcebergDestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.BufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.BufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.BufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CatalogConfiguration] inside the given [block]
         */
        public fun catalogConfiguration(block: aws.sdk.kotlin.services.firehose.model.CatalogConfiguration.Builder.() -> kotlin.Unit) {
            this.catalogConfiguration = aws.sdk.kotlin.services.firehose.model.CatalogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.RetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.RetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.RetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
