// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
 */
public class DocumentIdOptions private constructor(builder: Builder) {
    /**
     * When the `FIREHOSE_DEFAULT` option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
     *
     * When the `NO_DOCUMENT_ID` option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
     */
    public val defaultDocumentIdFormat: aws.sdk.kotlin.services.firehose.model.DefaultDocumentIdFormat = requireNotNull(builder.defaultDocumentIdFormat) { "A non-null value must be provided for defaultDocumentIdFormat" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DocumentIdOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentIdOptions(")
        append("defaultDocumentIdFormat=$defaultDocumentIdFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultDocumentIdFormat.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentIdOptions

        if (defaultDocumentIdFormat != other.defaultDocumentIdFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DocumentIdOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the `FIREHOSE_DEFAULT` option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
         *
         * When the `NO_DOCUMENT_ID` option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
         */
        public var defaultDocumentIdFormat: aws.sdk.kotlin.services.firehose.model.DefaultDocumentIdFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DocumentIdOptions) : this() {
            this.defaultDocumentIdFormat = x.defaultDocumentIdFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DocumentIdOptions = DocumentIdOptions(this)

        internal fun correctErrors(): Builder {
            if (defaultDocumentIdFormat == null) defaultDocumentIdFormat = DefaultDocumentIdFormat.SdkUnknown("no value provided")
            return this
        }
    }
}
