// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of a destination in Apache Iceberg Tables.
 *
 * Amazon Data Firehose is in preview release and is subject to change.
 */
public class DestinationTableConfiguration private constructor(builder: Builder) {
    /**
     * The name of the Apache Iceberg database.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val destinationDatabaseName: kotlin.String = requireNotNull(builder.destinationDatabaseName) { "A non-null value must be provided for destinationDatabaseName" }
    /**
     * Specifies the name of the Apache Iceberg Table.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val destinationTableName: kotlin.String = requireNotNull(builder.destinationTableName) { "A non-null value must be provided for destinationTableName" }
    /**
     * The table specific S3 error output prefix. All the errors that occurred while delivering to this table will be prefixed with this value in S3 destination.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val s3ErrorOutputPrefix: kotlin.String? = builder.s3ErrorOutputPrefix
    /**
     * A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create/Update/Delete operations on the given Iceberg table.
     *
     * Amazon Data Firehose is in preview release and is subject to change.
     */
    public val uniqueKeys: List<String>? = builder.uniqueKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DestinationTableConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationTableConfiguration(")
        append("destinationDatabaseName=$destinationDatabaseName,")
        append("destinationTableName=$destinationTableName,")
        append("s3ErrorOutputPrefix=$s3ErrorOutputPrefix,")
        append("uniqueKeys=$uniqueKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationDatabaseName.hashCode()
        result = 31 * result + (destinationTableName.hashCode())
        result = 31 * result + (s3ErrorOutputPrefix?.hashCode() ?: 0)
        result = 31 * result + (uniqueKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationTableConfiguration

        if (destinationDatabaseName != other.destinationDatabaseName) return false
        if (destinationTableName != other.destinationTableName) return false
        if (s3ErrorOutputPrefix != other.s3ErrorOutputPrefix) return false
        if (uniqueKeys != other.uniqueKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DestinationTableConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Apache Iceberg database.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var destinationDatabaseName: kotlin.String? = null
        /**
         * Specifies the name of the Apache Iceberg Table.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var destinationTableName: kotlin.String? = null
        /**
         * The table specific S3 error output prefix. All the errors that occurred while delivering to this table will be prefixed with this value in S3 destination.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var s3ErrorOutputPrefix: kotlin.String? = null
        /**
         * A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create/Update/Delete operations on the given Iceberg table.
         *
         * Amazon Data Firehose is in preview release and is subject to change.
         */
        public var uniqueKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DestinationTableConfiguration) : this() {
            this.destinationDatabaseName = x.destinationDatabaseName
            this.destinationTableName = x.destinationTableName
            this.s3ErrorOutputPrefix = x.s3ErrorOutputPrefix
            this.uniqueKeys = x.uniqueKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DestinationTableConfiguration = DestinationTableConfiguration(this)

        internal fun correctErrors(): Builder {
            if (destinationDatabaseName == null) destinationDatabaseName = ""
            if (destinationTableName == null) destinationTableName = ""
            return this
        }
    }
}
