// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
 */
public class DeliveryStreamEncryptionConfigurationInput private constructor(builder: Builder) {
    /**
     * If you set `KeyType` to `CUSTOMER_MANAGED_CMK`, you must specify the Amazon Resource Name (ARN) of the CMK. If you set `KeyType` to `Amazon Web Services_OWNED_CMK`, Firehose uses a service-account CMK.
     */
    public val keyArn: kotlin.String? = builder.keyArn
    /**
     * Indicates the type of customer master key (CMK) to use for encryption. The default setting is `Amazon Web Services_OWNED_CMK`. For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys). When you invoke CreateDeliveryStream or StartDeliveryStreamEncryption with `KeyType` set to CUSTOMER_MANAGED_CMK, Firehose invokes the Amazon KMS operation [CreateGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html) to create a grant that allows the Firehose service to use the customer managed CMK to perform encryption and decryption. Firehose manages that grant.
     *
     * When you invoke StartDeliveryStreamEncryption to change the CMK for a delivery stream that is encrypted with a customer managed CMK, Firehose schedules the grant it had on the old CMK for retirement.
     *
     * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a CreateDeliveryStream or StartDeliveryStreamEncryption operation exceeds this limit, Firehose throws a `LimitExceededException`.
     *
     * To encrypt your delivery stream, use symmetric CMKs. Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see [About Symmetric and Asymmetric CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html) in the Amazon Web Services Key Management Service developer guide.
     */
    public val keyType: aws.sdk.kotlin.services.firehose.model.KeyType = requireNotNull(builder.keyType) { "A non-null value must be provided for keyType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliveryStreamEncryptionConfigurationInput(")
        append("keyArn=$keyArn,")
        append("keyType=$keyType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyArn?.hashCode() ?: 0
        result = 31 * result + (keyType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliveryStreamEncryptionConfigurationInput

        if (keyArn != other.keyArn) return false
        if (keyType != other.keyType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you set `KeyType` to `CUSTOMER_MANAGED_CMK`, you must specify the Amazon Resource Name (ARN) of the CMK. If you set `KeyType` to `Amazon Web Services_OWNED_CMK`, Firehose uses a service-account CMK.
         */
        public var keyArn: kotlin.String? = null
        /**
         * Indicates the type of customer master key (CMK) to use for encryption. The default setting is `Amazon Web Services_OWNED_CMK`. For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys). When you invoke CreateDeliveryStream or StartDeliveryStreamEncryption with `KeyType` set to CUSTOMER_MANAGED_CMK, Firehose invokes the Amazon KMS operation [CreateGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html) to create a grant that allows the Firehose service to use the customer managed CMK to perform encryption and decryption. Firehose manages that grant.
         *
         * When you invoke StartDeliveryStreamEncryption to change the CMK for a delivery stream that is encrypted with a customer managed CMK, Firehose schedules the grant it had on the old CMK for retirement.
         *
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a CreateDeliveryStream or StartDeliveryStreamEncryption operation exceeds this limit, Firehose throws a `LimitExceededException`.
         *
         * To encrypt your delivery stream, use symmetric CMKs. Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see [About Symmetric and Asymmetric CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html) in the Amazon Web Services Key Management Service developer guide.
         */
        public var keyType: aws.sdk.kotlin.services.firehose.model.KeyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput) : this() {
            this.keyArn = x.keyArn
            this.keyType = x.keyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = DeliveryStreamEncryptionConfigurationInput(this)

        internal fun correctErrors(): Builder {
            if (keyType == null) keyType = KeyType.SdkUnknown("no value provided")
            return this
        }
    }
}
