// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the server-side encryption (SSE) status for the delivery stream, the type customer master key (CMK) in use, if any, and the ARN of the CMK. You can get `DeliveryStreamEncryptionConfiguration` by invoking the DescribeDeliveryStream operation.
 */
public class DeliveryStreamEncryptionConfiguration private constructor(builder: Builder) {
    /**
     * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
     */
    public val failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = builder.failureDescription
    /**
     * If `KeyType` is `CUSTOMER_MANAGED_CMK`, this field contains the ARN of the customer managed CMK. If `KeyType` is `Amazon Web Services_OWNED_CMK`, `DeliveryStreamEncryptionConfiguration` doesn't contain a value for `KeyARN`.
     */
    public val keyArn: kotlin.String? = builder.keyArn
    /**
     * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is `Amazon Web Services_OWNED_CMK`. For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
     */
    public val keyType: aws.sdk.kotlin.services.firehose.model.KeyType? = builder.keyType
    /**
     * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the different values of this status, see StartDeliveryStreamEncryption and StopDeliveryStreamEncryption. If this status is `ENABLING_FAILED` or `DISABLING_FAILED`, it is the status of the most recent attempt to enable or disable SSE, respectively.
     */
    public val status: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliveryStreamEncryptionConfiguration(")
        append("failureDescription=$failureDescription,")
        append("keyArn=$keyArn,")
        append("keyType=$keyType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureDescription?.hashCode() ?: 0
        result = 31 * result + (keyArn?.hashCode() ?: 0)
        result = 31 * result + (keyType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliveryStreamEncryptionConfiguration

        if (failureDescription != other.failureDescription) return false
        if (keyArn != other.keyArn) return false
        if (keyType != other.keyType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
         */
        public var failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = null
        /**
         * If `KeyType` is `CUSTOMER_MANAGED_CMK`, this field contains the ARN of the customer managed CMK. If `KeyType` is `Amazon Web Services_OWNED_CMK`, `DeliveryStreamEncryptionConfiguration` doesn't contain a value for `KeyARN`.
         */
        public var keyArn: kotlin.String? = null
        /**
         * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is `Amazon Web Services_OWNED_CMK`. For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
         */
        public var keyType: aws.sdk.kotlin.services.firehose.model.KeyType? = null
        /**
         * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the different values of this status, see StartDeliveryStreamEncryption and StopDeliveryStreamEncryption. If this status is `ENABLING_FAILED` or `DISABLING_FAILED`, it is the status of the most recent attempt to enable or disable SSE, respectively.
         */
        public var status: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration) : this() {
            this.failureDescription = x.failureDescription
            this.keyArn = x.keyArn
            this.keyType = x.keyType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration = DeliveryStreamEncryptionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.FailureDescription] inside the given [block]
         */
        public fun failureDescription(block: aws.sdk.kotlin.services.firehose.model.FailureDescription.Builder.() -> kotlin.Unit) {
            this.failureDescription = aws.sdk.kotlin.services.firehose.model.FailureDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
