// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes the configuration of a destination in Amazon Redshift.
 */
public class RedshiftDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The database connection string.
     */
    public val clusterJdbcurl: kotlin.String = requireNotNull(builder.clusterJdbcurl) { "A non-null value must be provided for clusterJdbcurl" }
    /**
     * The `COPY` command.
     */
    public val copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = builder.copyCommand
    /**
     * The user password.
     */
    public val password: kotlin.String = requireNotNull(builder.password) { "A non-null value must be provided for password" }
    /**
     * The data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The configuration for backup in Amazon S3.
     */
    public val s3BackupConfiguration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3BackupConfiguration
    /**
     * The Amazon S3 backup mode. After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = builder.s3BackupMode
    /**
     * The configuration for the intermediate Amazon S3 location from which Amazon Redshift obtains data. Restrictions are described in the topic for CreateDeliveryStream.
     *
     * The compression formats `SNAPPY` or `ZIP` cannot be specified in `RedshiftDestinationConfiguration.S3Configuration` because the Amazon Redshift `COPY` operation that reads from the S3 bucket doesn't support these compression formats.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The name of the user.
     */
    public val username: kotlin.String = requireNotNull(builder.username) { "A non-null value must be provided for username" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDestinationConfiguration(")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("clusterJdbcurl=$clusterJdbcurl,")
        append("copyCommand=$copyCommand,")
        append("password=*** Sensitive Data Redacted ***,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupConfiguration=$s3BackupConfiguration,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLoggingOptions?.hashCode() ?: 0
        result = 31 * result + (clusterJdbcurl.hashCode())
        result = 31 * result + (copyCommand?.hashCode() ?: 0)
        result = 31 * result + (password.hashCode())
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (s3BackupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (username.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDestinationConfiguration

        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (clusterJdbcurl != other.clusterJdbcurl) return false
        if (copyCommand != other.copyCommand) return false
        if (password != other.password) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupConfiguration != other.s3BackupConfiguration) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The database connection string.
         */
        public var clusterJdbcurl: kotlin.String? = null
        /**
         * The `COPY` command.
         */
        public var copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = null
        /**
         * The user password.
         */
        public var password: kotlin.String? = null
        /**
         * The data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The configuration for backup in Amazon S3.
         */
        public var s3BackupConfiguration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The Amazon S3 backup mode. After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = null
        /**
         * The configuration for the intermediate Amazon S3 location from which Amazon Redshift obtains data. Restrictions are described in the topic for CreateDeliveryStream.
         *
         * The compression formats `SNAPPY` or `ZIP` cannot be specified in `RedshiftDestinationConfiguration.S3Configuration` because the Amazon Redshift `COPY` operation that reads from the S3 bucket doesn't support these compression formats.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The name of the user.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.RedshiftDestinationConfiguration) : this() {
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.clusterJdbcurl = x.clusterJdbcurl
            this.copyCommand = x.copyCommand
            this.password = x.password
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupConfiguration = x.s3BackupConfiguration
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationConfiguration = RedshiftDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CopyCommand] inside the given [block]
         */
        public fun copyCommand(block: aws.sdk.kotlin.services.firehose.model.CopyCommand.Builder.() -> kotlin.Unit) {
            this.copyCommand = aws.sdk.kotlin.services.firehose.model.CopyCommand.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3BackupConfiguration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3BackupConfiguration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (clusterJdbcurl == null) clusterJdbcurl = ""
            if (password == null) password = ""
            if (roleArn == null) roleArn = ""
            if (username == null) username = ""
            return this
        }
    }
}
