// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
 */
public class OpenXJsonSerDe private constructor(builder: Builder) {
    /**
     * When set to `true`, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
     */
    public val caseInsensitive: kotlin.Boolean? = builder.caseInsensitive
    /**
     * Maps column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, `timestamp` is a Hive keyword. If you have a JSON key named `timestamp`, set this parameter to `{"ts": "timestamp"}` to map this key to a column named `ts`.
     */
    public val columnToJsonKeyMappings: Map<String, String>? = builder.columnToJsonKeyMappings
    /**
     * When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
     *
     * The default is `false`.
     */
    public val convertDotsInJsonKeysToUnderscores: kotlin.Boolean? = builder.convertDotsInJsonKeysToUnderscores

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenXJsonSerDe(")
        append("caseInsensitive=$caseInsensitive,")
        append("columnToJsonKeyMappings=$columnToJsonKeyMappings,")
        append("convertDotsInJsonKeysToUnderscores=$convertDotsInJsonKeysToUnderscores")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caseInsensitive?.hashCode() ?: 0
        result = 31 * result + (columnToJsonKeyMappings?.hashCode() ?: 0)
        result = 31 * result + (convertDotsInJsonKeysToUnderscores?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenXJsonSerDe

        if (caseInsensitive != other.caseInsensitive) return false
        if (columnToJsonKeyMappings != other.columnToJsonKeyMappings) return false
        if (convertDotsInJsonKeysToUnderscores != other.convertDotsInJsonKeysToUnderscores) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When set to `true`, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
         */
        public var caseInsensitive: kotlin.Boolean? = null
        /**
         * Maps column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, `timestamp` is a Hive keyword. If you have a JSON key named `timestamp`, set this parameter to `{"ts": "timestamp"}` to map this key to a column named `ts`.
         */
        public var columnToJsonKeyMappings: Map<String, String>? = null
        /**
         * When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
         *
         * The default is `false`.
         */
        public var convertDotsInJsonKeysToUnderscores: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe) : this() {
            this.caseInsensitive = x.caseInsensitive
            this.columnToJsonKeyMappings = x.columnToJsonKeyMappings
            this.convertDotsInJsonKeysToUnderscores = x.convertDotsInJsonKeysToUnderscores
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe = OpenXJsonSerDe(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
