// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about the Amazon MSK cluster used as the source for a Kinesis Data Firehose delivery stream.
 */
public class MskSourceDescription private constructor(builder: Builder) {
    /**
     * The authentication configuration of the Amazon MSK cluster.
     */
    public val authenticationConfiguration: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration? = builder.authenticationConfiguration
    /**
     * Kinesis Data Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this timestamp.
     */
    public val deliveryStartTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.deliveryStartTimestamp
    /**
     * The ARN of the Amazon MSK cluster.
     */
    public val mskClusterArn: kotlin.String? = builder.mskClusterArn
    /**
     * The topic name within the Amazon MSK cluster.
     */
    public val topicName: kotlin.String? = builder.topicName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.MskSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MskSourceDescription(")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("deliveryStartTimestamp=$deliveryStartTimestamp,")
        append("mskClusterArn=$mskClusterArn,")
        append("topicName=$topicName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfiguration?.hashCode() ?: 0
        result = 31 * result + (deliveryStartTimestamp?.hashCode() ?: 0)
        result = 31 * result + (mskClusterArn?.hashCode() ?: 0)
        result = 31 * result + (topicName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MskSourceDescription

        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (deliveryStartTimestamp != other.deliveryStartTimestamp) return false
        if (mskClusterArn != other.mskClusterArn) return false
        if (topicName != other.topicName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.MskSourceDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication configuration of the Amazon MSK cluster.
         */
        public var authenticationConfiguration: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration? = null
        /**
         * Kinesis Data Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this timestamp.
         */
        public var deliveryStartTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the Amazon MSK cluster.
         */
        public var mskClusterArn: kotlin.String? = null
        /**
         * The topic name within the Amazon MSK cluster.
         */
        public var topicName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.MskSourceDescription) : this() {
            this.authenticationConfiguration = x.authenticationConfiguration
            this.deliveryStartTimestamp = x.deliveryStartTimestamp
            this.mskClusterArn = x.mskClusterArn
            this.topicName = x.topicName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.MskSourceDescription = MskSourceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration] inside the given [block]
         */
        public fun authenticationConfiguration(block: aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.authenticationConfiguration = aws.sdk.kotlin.services.firehose.model.AuthenticationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
