// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes an update for a destination in Amazon S3.
 */
public class ExtendedS3DestinationUpdate private constructor(builder: Builder) {
    /**
     * The ARN of the S3 bucket. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The buffering option.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = builder.bufferingHints
    /**
     * The Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The compression format. If no value is specified, the default is `UNCOMPRESSED`.
     */
    public val compressionFormat: aws.sdk.kotlin.services.firehose.model.CompressionFormat? = builder.compressionFormat
    /**
     * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
     */
    public val dataFormatConversionConfiguration: aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration? = builder.dataFormatConversionConfiguration
    /**
     * The configuration of the dynamic partitioning mechanism that creates smaller data sets from the streaming data by partitioning it based on partition keys. Currently, dynamic partitioning is only supported for Amazon S3 destinations.
     */
    public val dynamicPartitioningConfiguration: aws.sdk.kotlin.services.firehose.model.DynamicPartitioningConfiguration? = builder.dynamicPartitioningConfiguration
    /**
     * The encryption configuration. If no value is specified, the default is no encryption.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    public val errorOutputPrefix: kotlin.String? = builder.errorOutputPrefix
    /**
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * You can update a delivery stream to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.S3BackupMode? = builder.s3BackupMode
    /**
     * The Amazon S3 destination for backup.
     */
    public val s3BackupUpdate: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = builder.s3BackupUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.ExtendedS3DestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExtendedS3DestinationUpdate(")
        append("bucketArn=$bucketArn,")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("compressionFormat=$compressionFormat,")
        append("dataFormatConversionConfiguration=$dataFormatConversionConfiguration,")
        append("dynamicPartitioningConfiguration=$dynamicPartitioningConfiguration,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("errorOutputPrefix=$errorOutputPrefix,")
        append("prefix=$prefix,")
        append("processingConfiguration=$processingConfiguration,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3BackupUpdate=$s3BackupUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (bufferingHints?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (compressionFormat?.hashCode() ?: 0)
        result = 31 * result + (dataFormatConversionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dynamicPartitioningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (errorOutputPrefix?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3BackupUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExtendedS3DestinationUpdate

        if (bucketArn != other.bucketArn) return false
        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (compressionFormat != other.compressionFormat) return false
        if (dataFormatConversionConfiguration != other.dataFormatConversionConfiguration) return false
        if (dynamicPartitioningConfiguration != other.dynamicPartitioningConfiguration) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (errorOutputPrefix != other.errorOutputPrefix) return false
        if (prefix != other.prefix) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3BackupUpdate != other.s3BackupUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.ExtendedS3DestinationUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the S3 bucket. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The buffering option.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = null
        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The compression format. If no value is specified, the default is `UNCOMPRESSED`.
         */
        public var compressionFormat: aws.sdk.kotlin.services.firehose.model.CompressionFormat? = null
        /**
         * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
         */
        public var dataFormatConversionConfiguration: aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration? = null
        /**
         * The configuration of the dynamic partitioning mechanism that creates smaller data sets from the streaming data by partitioning it based on partition keys. Currently, dynamic partitioning is only supported for Amazon S3 destinations.
         */
        public var dynamicPartitioningConfiguration: aws.sdk.kotlin.services.firehose.model.DynamicPartitioningConfiguration? = null
        /**
         * The encryption configuration. If no value is specified, the default is no encryption.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration? = null
        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
         */
        public var errorOutputPrefix: kotlin.String? = null
        /**
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
         */
        public var prefix: kotlin.String? = null
        /**
         * The data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * You can update a delivery stream to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the delivery stream to disable it.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.S3BackupMode? = null
        /**
         * The Amazon S3 destination for backup.
         */
        public var s3BackupUpdate: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.ExtendedS3DestinationUpdate) : this() {
            this.bucketArn = x.bucketArn
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.compressionFormat = x.compressionFormat
            this.dataFormatConversionConfiguration = x.dataFormatConversionConfiguration
            this.dynamicPartitioningConfiguration = x.dynamicPartitioningConfiguration
            this.encryptionConfiguration = x.encryptionConfiguration
            this.errorOutputPrefix = x.errorOutputPrefix
            this.prefix = x.prefix
            this.processingConfiguration = x.processingConfiguration
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3BackupUpdate = x.s3BackupUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.ExtendedS3DestinationUpdate = ExtendedS3DestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.BufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.BufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.BufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration] inside the given [block]
         */
        public fun dataFormatConversionConfiguration(block: aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration.Builder.() -> kotlin.Unit) {
            this.dataFormatConversionConfiguration = aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DynamicPartitioningConfiguration] inside the given [block]
         */
        public fun dynamicPartitioningConfiguration(block: aws.sdk.kotlin.services.firehose.model.DynamicPartitioningConfiguration.Builder.() -> kotlin.Unit) {
            this.dynamicPartitioningConfiguration = aws.sdk.kotlin.services.firehose.model.DynamicPartitioningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate] inside the given [block]
         */
        public fun s3BackupUpdate(block: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.Builder.() -> kotlin.Unit) {
            this.s3BackupUpdate = aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
