// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * The deserializer you want Kinesis Data Firehose to use for converting the input data from JSON. Kinesis Data Firehose then serializes the data to its final format using the Serializer. Kinesis Data Firehose supports two types of deserializers: the [Apache Hive JSON SerDe](https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON) and the [OpenX JSON SerDe](https://github.com/rcongiu/Hive-JSON-Serde).
 */
public class Deserializer private constructor(builder: Builder) {
    /**
     * The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
     */
    public val hiveJsonSerDe: aws.sdk.kotlin.services.firehose.model.HiveJsonSerDe? = builder.hiveJsonSerDe
    /**
     * The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
     */
    public val openXJsonSerDe: aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe? = builder.openXJsonSerDe

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.Deserializer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deserializer(")
        append("hiveJsonSerDe=$hiveJsonSerDe,")
        append("openXJsonSerDe=$openXJsonSerDe")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hiveJsonSerDe?.hashCode() ?: 0
        result = 31 * result + (openXJsonSerDe?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deserializer

        if (hiveJsonSerDe != other.hiveJsonSerDe) return false
        if (openXJsonSerDe != other.openXJsonSerDe) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.Deserializer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
         */
        public var hiveJsonSerDe: aws.sdk.kotlin.services.firehose.model.HiveJsonSerDe? = null
        /**
         * The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
         */
        public var openXJsonSerDe: aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.Deserializer) : this() {
            this.hiveJsonSerDe = x.hiveJsonSerDe
            this.openXJsonSerDe = x.openXJsonSerDe
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.Deserializer = Deserializer(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HiveJsonSerDe] inside the given [block]
         */
        public fun hiveJsonSerDe(block: aws.sdk.kotlin.services.firehose.model.HiveJsonSerDe.Builder.() -> kotlin.Unit) {
            this.hiveJsonSerDe = aws.sdk.kotlin.services.firehose.model.HiveJsonSerDe.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe] inside the given [block]
         */
        public fun openXJsonSerDe(block: aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe.Builder.() -> kotlin.Unit) {
            this.openXJsonSerDe = aws.sdk.kotlin.services.firehose.model.OpenXJsonSerDe.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
