// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Kinesis Data Firehose might choose to use different values when it is optimal. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
 */
public class BufferingHints private constructor(builder: Builder) {
    /**
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300. This parameter is optional but if you specify a value for it, you must also specify a value for `SizeInMBs`, and vice versa.
     */
    public val intervalInSeconds: kotlin.Int? = builder.intervalInSeconds
    /**
     * Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default value is 5. This parameter is optional but if you specify a value for it, you must also specify a value for `IntervalInSeconds`, and vice versa.
     *
     * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value should be 10 MiB or higher.
     */
    public val sizeInMbs: kotlin.Int? = builder.sizeInMbs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.BufferingHints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BufferingHints(")
        append("intervalInSeconds=$intervalInSeconds,")
        append("sizeInMbs=$sizeInMbs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intervalInSeconds ?: 0
        result = 31 * result + (sizeInMbs ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BufferingHints

        if (intervalInSeconds != other.intervalInSeconds) return false
        if (sizeInMbs != other.sizeInMbs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.BufferingHints = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300. This parameter is optional but if you specify a value for it, you must also specify a value for `SizeInMBs`, and vice versa.
         */
        public var intervalInSeconds: kotlin.Int? = null
        /**
         * Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default value is 5. This parameter is optional but if you specify a value for it, you must also specify a value for `IntervalInSeconds`, and vice versa.
         *
         * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value should be 10 MiB or higher.
         */
        public var sizeInMbs: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.BufferingHints) : this() {
            this.intervalInSeconds = x.intervalInSeconds
            this.sizeInMbs = x.sizeInMbs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.BufferingHints = BufferingHints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
