// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * The serializer that you want Kinesis Data Firehose to use to convert data to the target format before writing it to Amazon S3. Kinesis Data Firehose supports two types of serializers: the [ORC SerDe](https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html) and the [Parquet SerDe](https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html).
 */
public class Serializer private constructor(builder: Builder) {
    /**
     * A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see [Apache ORC](https://orc.apache.org/docs/).
     */
    public val orcSerDe: aws.sdk.kotlin.services.firehose.model.OrcSerDe? = builder.orcSerDe
    /**
     * A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see [Apache Parquet](https://parquet.apache.org/documentation/latest/).
     */
    public val parquetSerDe: aws.sdk.kotlin.services.firehose.model.ParquetSerDe? = builder.parquetSerDe

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.Serializer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Serializer(")
        append("orcSerDe=$orcSerDe,")
        append("parquetSerDe=$parquetSerDe")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = orcSerDe?.hashCode() ?: 0
        result = 31 * result + (parquetSerDe?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Serializer

        if (orcSerDe != other.orcSerDe) return false
        if (parquetSerDe != other.parquetSerDe) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.Serializer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see [Apache ORC](https://orc.apache.org/docs/).
         */
        public var orcSerDe: aws.sdk.kotlin.services.firehose.model.OrcSerDe? = null
        /**
         * A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see [Apache Parquet](https://parquet.apache.org/documentation/latest/).
         */
        public var parquetSerDe: aws.sdk.kotlin.services.firehose.model.ParquetSerDe? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.Serializer) : this() {
            this.orcSerDe = x.orcSerDe
            this.parquetSerDe = x.parquetSerDe
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.Serializer = Serializer(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.OrcSerDe] inside the given [block]
         */
        public fun orcSerDe(block: aws.sdk.kotlin.services.firehose.model.OrcSerDe.Builder.() -> kotlin.Unit) {
            this.orcSerDe = aws.sdk.kotlin.services.firehose.model.OrcSerDe.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ParquetSerDe] inside the given [block]
         */
        public fun parquetSerDe(block: aws.sdk.kotlin.services.firehose.model.ParquetSerDe.Builder.() -> kotlin.Unit) {
            this.parquetSerDe = aws.sdk.kotlin.services.firehose.model.ParquetSerDe.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
