// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.firehose.auth.DefaultFirehoseAuthSchemeProvider
import aws.sdk.kotlin.services.firehose.auth.FirehoseAuthSchemeProvider
import aws.sdk.kotlin.services.firehose.endpoints.DefaultFirehoseEndpointProvider
import aws.sdk.kotlin.services.firehose.endpoints.FirehoseEndpointParameters
import aws.sdk.kotlin.services.firehose.endpoints.FirehoseEndpointProvider
import aws.sdk.kotlin.services.firehose.model.CreateDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.CreateDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.DeleteDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.DeleteDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.DescribeDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.DescribeDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsRequest
import aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsResponse
import aws.sdk.kotlin.services.firehose.model.ListTagsForDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.ListTagsForDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.PutRecordBatchRequest
import aws.sdk.kotlin.services.firehose.model.PutRecordBatchResponse
import aws.sdk.kotlin.services.firehose.model.PutRecordRequest
import aws.sdk.kotlin.services.firehose.model.PutRecordResponse
import aws.sdk.kotlin.services.firehose.model.StartDeliveryStreamEncryptionRequest
import aws.sdk.kotlin.services.firehose.model.StartDeliveryStreamEncryptionResponse
import aws.sdk.kotlin.services.firehose.model.StopDeliveryStreamEncryptionRequest
import aws.sdk.kotlin.services.firehose.model.StopDeliveryStreamEncryptionResponse
import aws.sdk.kotlin.services.firehose.model.TagDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.TagDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.UntagDeliveryStreamRequest
import aws.sdk.kotlin.services.firehose.model.UntagDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.UpdateDestinationRequest
import aws.sdk.kotlin.services.firehose.model.UpdateDestinationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Firehose"
public const val SdkVersion: String = "1.0.14"

/**
 * # Amazon Kinesis Data Firehose API Reference
 * Amazon Kinesis Data Firehose is a fully managed service that delivers real-time streaming data to destinations such as Amazon Simple Storage Service (Amazon S3), Amazon OpenSearch Service, Amazon Redshift, Splunk, and various other supportd destinations.
 */
public interface FirehoseClient : SdkClient {
    /**
     * FirehoseClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, FirehoseClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Firehose",
                "FIREHOSE",
                "firehose",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, FirehoseClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): FirehoseClient = DefaultFirehoseClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: FirehoseEndpointProvider = builder.endpointProvider ?: DefaultFirehoseEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: FirehoseAuthSchemeProvider = builder.authSchemeProvider ?: DefaultFirehoseAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Firehose"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: FirehoseEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: FirehoseAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Kinesis Data Firehose delivery stream.
     *
     * By default, you can create up to 50 delivery streams per Amazon Web Services Region.
     *
     * This is an asynchronous operation that immediately returns. The initial status of the delivery stream is `CREATING`. After the delivery stream is created, its status is `ACTIVE` and it now accepts data. If the delivery stream creation fails, the status transitions to `CREATING_FAILED`. Attempts to send data to a delivery stream that is not in the `ACTIVE` state cause an exception. To check the state of a delivery stream, use DescribeDeliveryStream.
     *
     * If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke `CreateDeliveryStream` again on it. However, you can invoke the DeleteDeliveryStream operation to delete it.
     *
     * A Kinesis Data Firehose delivery stream can be configured to receive records directly from providers using PutRecord or PutRecordBatch, or it can be configured to use an existing Kinesis stream as its source. To specify a Kinesis data stream as input, set the `DeliveryStreamType` parameter to `KinesisStreamAsSource`, and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in the `KinesisStreamSourceConfiguration` parameter.
     *
     * To create a delivery stream with server-side encryption (SSE) enabled, include DeliveryStreamEncryptionConfigurationInput in your request. This is optional. You can also invoke StartDeliveryStreamEncryption to turn on SSE for an existing delivery stream that doesn't have SSE enabled.
     *
     * A delivery stream is configured with a single destination, such as Amazon Simple Storage Service (Amazon S3), Amazon Redshift, Amazon OpenSearch Service, Amazon OpenSearch Serverless, Splunk, and any custom HTTP endpoint or HTTP endpoints owned by or supported by third-party service providers, including Datadog, Dynatrace, LogicMonitor, MongoDB, New Relic, and Sumo Logic. You must specify only one of the following destination configuration parameters: `ExtendedS3DestinationConfiguration`, `S3DestinationConfiguration`, `ElasticsearchDestinationConfiguration`, `RedshiftDestinationConfiguration`, or `SplunkDestinationConfiguration`.
     *
     * When you specify `S3DestinationConfiguration`, you can also provide the following optional values: BufferingHints, `EncryptionConfiguration`, and `CompressionFormat`. By default, if no `BufferingHints` value is provided, Kinesis Data Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. `BufferingHints` is a hint, so there are some cases where the service cannot adhere to these conditions strictly. For example, record boundaries might be such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3.
     *
     * A few notes about Amazon Redshift as a destination:
     * + An Amazon Redshift destination requires an S3 bucket as intermediate location. Kinesis Data Firehose first delivers data to Amazon S3 and then uses `COPY` syntax to load data into an Amazon Redshift table. This is specified in the `RedshiftDestinationConfiguration.S3Configuration` parameter.
     * + The compression formats `SNAPPY` or `ZIP` cannot be specified in `RedshiftDestinationConfiguration.S3Configuration` because the Amazon Redshift `COPY` operation that reads from the S3 bucket doesn't support these compression formats.
     * + We strongly recommend that you use the user name and password you provide exclusively with Kinesis Data Firehose, and that the permissions for the account are restricted for Amazon Redshift `INSERT` permissions.
     *
     * Kinesis Data Firehose assumes the IAM role that is configured as part of the destination. The role should allow the Kinesis Data Firehose principal to assume the role, and the role should have permissions that allow the service to deliver the data. For more information, see [Grant Kinesis Data Firehose Access to an Amazon S3 Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3) in the *Amazon Kinesis Data Firehose Developer Guide*.
     */
    public suspend fun createDeliveryStream(input: CreateDeliveryStreamRequest): CreateDeliveryStreamResponse

    /**
     * Deletes a delivery stream and its data.
     *
     * To check the state of a delivery stream, use DescribeDeliveryStream. You can delete a delivery stream only if it is in one of the following states: `ACTIVE`, `DELETING`, `CREATING_FAILED`, or `DELETING_FAILED`. You can't delete a delivery stream that is in the `CREATING` state. While the deletion request is in process, the delivery stream is in the `DELETING` state.
     *
     * While the delivery stream is in the `DELETING` state, the service might continue to accept records, but it doesn't make any guarantees with respect to delivering the data. Therefore, as a best practice, first stop any applications that are sending records before you delete a delivery stream.
     */
    public suspend fun deleteDeliveryStream(input: DeleteDeliveryStreamRequest): DeleteDeliveryStreamResponse

    /**
     * Describes the specified delivery stream and its status. For example, after your delivery stream is created, call `DescribeDeliveryStream` to see whether the delivery stream is `ACTIVE` and therefore ready for data to be sent to it.
     *
     * If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke CreateDeliveryStream again on it. However, you can invoke the DeleteDeliveryStream operation to delete it. If the status is `DELETING_FAILED`, you can force deletion by invoking DeleteDeliveryStream again but with DeleteDeliveryStreamInput$AllowForceDelete set to true.
     */
    public suspend fun describeDeliveryStream(input: DescribeDeliveryStreamRequest): DescribeDeliveryStreamResponse

    /**
     * Lists your delivery streams in alphabetical order of their names.
     *
     * The number of delivery streams might be too large to return using a single call to `ListDeliveryStreams`. You can limit the number of delivery streams returned, using the `Limit` parameter. To determine whether there are more delivery streams to list, check the value of `HasMoreDeliveryStreams` in the output. If there are more delivery streams to list, you can request them by calling this operation again and setting the `ExclusiveStartDeliveryStreamName` parameter to the name of the last delivery stream returned in the last call.
     */
    public suspend fun listDeliveryStreams(input: ListDeliveryStreamsRequest = ListDeliveryStreamsRequest { }): ListDeliveryStreamsResponse

    /**
     * Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account.
     */
    public suspend fun listTagsForDeliveryStream(input: ListTagsForDeliveryStreamRequest): ListTagsForDeliveryStreamResponse

    /**
     * Writes a single data record into an Amazon Kinesis Data Firehose delivery stream. To write multiple data records into a delivery stream, use PutRecordBatch. Applications using these operations are referred to as producers.
     *
     * By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. If you use PutRecord and PutRecordBatch, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see [Amazon Kinesis Data Firehose Limits](https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
     *
     * Kinesis Data Firehose accumulates and publishes a particular metric for a customer account in one minute intervals. It is possible that the bursts of incoming bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the actual spikes in the traffic might not be fully visible in the customer's 1 minute CloudWatch metrics.
     *
     * You must specify the name of the delivery stream and the data record when using PutRecord. The data record consists of a data blob that can be up to 1,000 KiB in size, and any kind of data. For example, it can be a segment from a log file, geographic location data, website clickstream data, and so on.
     *
     * Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (`\n`) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.
     *
     * The `PutRecord` operation returns a `RecordId`, which is a unique string assigned to each record. Producer applications can use this ID for purposes such as auditability and investigation.
     *
     * If the `PutRecord` operation throws a `ServiceUnavailableException`, the API is automatically reinvoked (retried) 3 times. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.
     *
     * Re-invoking the Put API operations (for example, PutRecord and PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer time out before retrying Put API operations.
     *
     * Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it tries to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.
     *
     * Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.
     */
    public suspend fun putRecord(input: PutRecordRequest): PutRecordResponse

    /**
     * Writes multiple data records into a delivery stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a delivery stream, use PutRecord. Applications using these operations are referred to as producers.
     *
     * Kinesis Data Firehose accumulates and publishes a particular metric for a customer account in one minute intervals. It is possible that the bursts of incoming bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the actual spikes in the traffic might not be fully visible in the customer's 1 minute CloudWatch metrics.
     *
     * For information about service quota, see [Amazon Kinesis Data Firehose Quota](https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
     *
     * Each PutRecordBatch request supports up to 500 records. Each record in the request can be as large as 1,000 KB (before base64 encoding), up to a limit of 4 MB for the entire request. These limits cannot be changed.
     *
     * You must specify the name of the delivery stream and the data record when using PutRecord. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data. For example, it could be a segment from a log file, geographic location data, website clickstream data, and so on.
     *
     * Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (`\n`) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.
     *
     * The PutRecordBatch response includes a count of failed records, `FailedPutCount`, and an array of responses, `RequestResponses`. Even if the PutRecordBatch call succeeds, the value of `FailedPutCount` may be greater than 0, indicating that there are records for which the operation didn't succeed. Each entry in the `RequestResponses` array provides additional information about the processed record. It directly correlates with a record in the request array using the same ordering, from the top to the bottom. The response array always includes the same number of records as the request array. `RequestResponses` includes both successfully and unsuccessfully processed records. Kinesis Data Firehose tries to process all records in each PutRecordBatch request. A single record failure does not stop the processing of subsequent records.
     *
     * A successfully processed record includes a `RecordId` value, which is unique for the record. An unsuccessfully processed record includes `ErrorCode` and `ErrorMessage` values. `ErrorCode` reflects the type of error, and is one of the following values: `ServiceUnavailableException` or `InternalFailure`. `ErrorMessage` provides more detailed information about the error.
     *
     * If there is an internal server error or a timeout, the write might have completed or it might have failed. If `FailedPutCount` is greater than 0, retry the request, resending only those records that might have failed processing. This minimizes the possible duplicate records and also reduces the total bytes sent (and corresponding charges). We recommend that you handle any duplicates at the destination.
     *
     * If PutRecordBatch throws `ServiceUnavailableException`, the API is automatically reinvoked (retried) 3 times. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.
     *
     * Re-invoking the Put API operations (for example, PutRecord and PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer time out before retrying Put API operations.
     *
     * Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.
     *
     * Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.
     */
    public suspend fun putRecordBatch(input: PutRecordBatchRequest): PutRecordBatchResponse

    /**
     * Enables server-side encryption (SSE) for the delivery stream.
     *
     * This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to `ENABLING`, and then to `ENABLED`. The encryption status of a delivery stream is the `Status` property in DeliveryStreamEncryptionConfiguration. If the operation fails, the encryption status changes to `ENABLING_FAILED`. You can continue to read and write data to your delivery stream while the encryption status is `ENABLING`, but the data is not encrypted. It can take up to 5 seconds after the encryption status changes to `ENABLED` before all records written to the delivery stream are encrypted. To find out whether a record or a batch of records was encrypted, check the response elements PutRecordOutput$Encrypted and PutRecordBatchOutput$Encrypted, respectively.
     *
     * To check the encryption status of a delivery stream, use DescribeDeliveryStream.
     *
     * Even if encryption is currently enabled for a delivery stream, you can still invoke this operation on it to change the ARN of the CMK or both its type and ARN. If you invoke this method to change the CMK, and the old CMK is of type `CUSTOMER_MANAGED_CMK`, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement. If the new CMK is of type `CUSTOMER_MANAGED_CMK`, Kinesis Data Firehose creates a grant that enables it to use the new CMK to encrypt and decrypt data and to manage the grant.
     *
     * For the KMS grant creation to be successful, Kinesis Data Firehose APIs `StartDeliveryStreamEncryption` and `CreateDeliveryStream` should not be called with session credentials that are more than 6 hours old.
     *
     * If a delivery stream already has encryption enabled and then you invoke this operation to change the ARN of the CMK or both its type and ARN and you get `ENABLING_FAILED`, this only means that the attempt to change the CMK failed. In this case, encryption remains enabled with the old CMK.
     *
     * If the encryption status of your delivery stream is `ENABLING_FAILED`, you can invoke this operation again with a valid CMK. The CMK must be enabled and the key policy mustn't explicitly deny the permission for Kinesis Data Firehose to invoke KMS encrypt and decrypt operations.
     *
     * You can enable SSE for a delivery stream only if it's a delivery stream that uses `DirectPut` as its source.
     *
     * The `StartDeliveryStreamEncryption` and `StopDeliveryStreamEncryption` operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call `StartDeliveryStreamEncryption` 13 times and `StopDeliveryStreamEncryption` 12 times for the same delivery stream in a 24-hour period.
     */
    public suspend fun startDeliveryStreamEncryption(input: StartDeliveryStreamEncryptionRequest): StartDeliveryStreamEncryptionResponse

    /**
     * Disables server-side encryption (SSE) for the delivery stream.
     *
     * This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to `DISABLING`, and then to `DISABLED`. You can continue to read and write data to your stream while its status is `DISABLING`. It can take up to 5 seconds after the encryption status changes to `DISABLED` before all records written to the delivery stream are no longer subject to encryption. To find out whether a record or a batch of records was encrypted, check the response elements PutRecordOutput$Encrypted and PutRecordBatchOutput$Encrypted, respectively.
     *
     * To check the encryption state of a delivery stream, use DescribeDeliveryStream.
     *
     * If SSE is enabled using a customer managed CMK and then you invoke `StopDeliveryStreamEncryption`, Kinesis Data Firehose schedules the related KMS grant for retirement and then retires it after it ensures that it is finished delivering records to the destination.
     *
     * The `StartDeliveryStreamEncryption` and `StopDeliveryStreamEncryption` operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call `StartDeliveryStreamEncryption` 13 times and `StopDeliveryStreamEncryption` 12 times for the same delivery stream in a 24-hour period.
     */
    public suspend fun stopDeliveryStreamEncryption(input: StopDeliveryStreamEncryptionRequest): StopDeliveryStreamEncryptionResponse

    /**
     * Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*.
     *
     * Each delivery stream can have up to 50 tags.
     *
     * This operation has a limit of five transactions per second per account.
     */
    public suspend fun tagDeliveryStream(input: TagDeliveryStreamRequest): TagDeliveryStreamResponse

    /**
     * Removes tags from the specified delivery stream. Removed tags are deleted, and you can't recover them after this operation successfully completes.
     *
     * If you specify a tag that doesn't exist, the operation ignores it.
     *
     * This operation has a limit of five transactions per second per account.
     */
    public suspend fun untagDeliveryStream(input: UntagDeliveryStreamRequest): UntagDeliveryStreamResponse

    /**
     * Updates the specified destination of the specified delivery stream.
     *
     * Use this operation to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift) or change the parameters associated with a destination (for example, to change the bucket name of the Amazon S3 destination). The update might not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are usually effective within a few minutes.
     *
     * Switching between Amazon OpenSearch Service and other services is not supported. For an Amazon OpenSearch Service destination, you can only update to another Amazon OpenSearch Service destination.
     *
     * If the destination type is the same, Kinesis Data Firehose merges the configuration parameters specified with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the call, the existing values are retained. For example, in the Amazon S3 destination, if EncryptionConfiguration is not specified, then the existing `EncryptionConfiguration` is maintained on the destination.
     *
     * If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any parameters. In this case, all parameters must be specified.
     *
     * Kinesis Data Firehose uses `CurrentDeliveryStreamVersionId` to avoid race conditions and conflicting merges. This is a required field, and the service updates the configuration only if the existing configuration has a version ID that matches. After the update is applied successfully, the version ID is updated, and can be retrieved using DescribeDeliveryStream. Use the new version ID to set `CurrentDeliveryStreamVersionId` in the next call.
     */
    public suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun FirehoseClient.withConfig(block: FirehoseClient.Config.Builder.() -> Unit): FirehoseClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultFirehoseClient(newConfig)
}

/**
 * Creates a Kinesis Data Firehose delivery stream.
 *
 * By default, you can create up to 50 delivery streams per Amazon Web Services Region.
 *
 * This is an asynchronous operation that immediately returns. The initial status of the delivery stream is `CREATING`. After the delivery stream is created, its status is `ACTIVE` and it now accepts data. If the delivery stream creation fails, the status transitions to `CREATING_FAILED`. Attempts to send data to a delivery stream that is not in the `ACTIVE` state cause an exception. To check the state of a delivery stream, use DescribeDeliveryStream.
 *
 * If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke `CreateDeliveryStream` again on it. However, you can invoke the DeleteDeliveryStream operation to delete it.
 *
 * A Kinesis Data Firehose delivery stream can be configured to receive records directly from providers using PutRecord or PutRecordBatch, or it can be configured to use an existing Kinesis stream as its source. To specify a Kinesis data stream as input, set the `DeliveryStreamType` parameter to `KinesisStreamAsSource`, and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in the `KinesisStreamSourceConfiguration` parameter.
 *
 * To create a delivery stream with server-side encryption (SSE) enabled, include DeliveryStreamEncryptionConfigurationInput in your request. This is optional. You can also invoke StartDeliveryStreamEncryption to turn on SSE for an existing delivery stream that doesn't have SSE enabled.
 *
 * A delivery stream is configured with a single destination, such as Amazon Simple Storage Service (Amazon S3), Amazon Redshift, Amazon OpenSearch Service, Amazon OpenSearch Serverless, Splunk, and any custom HTTP endpoint or HTTP endpoints owned by or supported by third-party service providers, including Datadog, Dynatrace, LogicMonitor, MongoDB, New Relic, and Sumo Logic. You must specify only one of the following destination configuration parameters: `ExtendedS3DestinationConfiguration`, `S3DestinationConfiguration`, `ElasticsearchDestinationConfiguration`, `RedshiftDestinationConfiguration`, or `SplunkDestinationConfiguration`.
 *
 * When you specify `S3DestinationConfiguration`, you can also provide the following optional values: BufferingHints, `EncryptionConfiguration`, and `CompressionFormat`. By default, if no `BufferingHints` value is provided, Kinesis Data Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. `BufferingHints` is a hint, so there are some cases where the service cannot adhere to these conditions strictly. For example, record boundaries might be such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3.
 *
 * A few notes about Amazon Redshift as a destination:
 * + An Amazon Redshift destination requires an S3 bucket as intermediate location. Kinesis Data Firehose first delivers data to Amazon S3 and then uses `COPY` syntax to load data into an Amazon Redshift table. This is specified in the `RedshiftDestinationConfiguration.S3Configuration` parameter.
 * + The compression formats `SNAPPY` or `ZIP` cannot be specified in `RedshiftDestinationConfiguration.S3Configuration` because the Amazon Redshift `COPY` operation that reads from the S3 bucket doesn't support these compression formats.
 * + We strongly recommend that you use the user name and password you provide exclusively with Kinesis Data Firehose, and that the permissions for the account are restricted for Amazon Redshift `INSERT` permissions.
 *
 * Kinesis Data Firehose assumes the IAM role that is configured as part of the destination. The role should allow the Kinesis Data Firehose principal to assume the role, and the role should have permissions that allow the service to deliver the data. For more information, see [Grant Kinesis Data Firehose Access to an Amazon S3 Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3) in the *Amazon Kinesis Data Firehose Developer Guide*.
 */
public suspend inline fun FirehoseClient.createDeliveryStream(crossinline block: CreateDeliveryStreamRequest.Builder.() -> Unit): CreateDeliveryStreamResponse = createDeliveryStream(CreateDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Deletes a delivery stream and its data.
 *
 * To check the state of a delivery stream, use DescribeDeliveryStream. You can delete a delivery stream only if it is in one of the following states: `ACTIVE`, `DELETING`, `CREATING_FAILED`, or `DELETING_FAILED`. You can't delete a delivery stream that is in the `CREATING` state. While the deletion request is in process, the delivery stream is in the `DELETING` state.
 *
 * While the delivery stream is in the `DELETING` state, the service might continue to accept records, but it doesn't make any guarantees with respect to delivering the data. Therefore, as a best practice, first stop any applications that are sending records before you delete a delivery stream.
 */
public suspend inline fun FirehoseClient.deleteDeliveryStream(crossinline block: DeleteDeliveryStreamRequest.Builder.() -> Unit): DeleteDeliveryStreamResponse = deleteDeliveryStream(DeleteDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Describes the specified delivery stream and its status. For example, after your delivery stream is created, call `DescribeDeliveryStream` to see whether the delivery stream is `ACTIVE` and therefore ready for data to be sent to it.
 *
 * If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke CreateDeliveryStream again on it. However, you can invoke the DeleteDeliveryStream operation to delete it. If the status is `DELETING_FAILED`, you can force deletion by invoking DeleteDeliveryStream again but with DeleteDeliveryStreamInput$AllowForceDelete set to true.
 */
public suspend inline fun FirehoseClient.describeDeliveryStream(crossinline block: DescribeDeliveryStreamRequest.Builder.() -> Unit): DescribeDeliveryStreamResponse = describeDeliveryStream(DescribeDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Lists your delivery streams in alphabetical order of their names.
 *
 * The number of delivery streams might be too large to return using a single call to `ListDeliveryStreams`. You can limit the number of delivery streams returned, using the `Limit` parameter. To determine whether there are more delivery streams to list, check the value of `HasMoreDeliveryStreams` in the output. If there are more delivery streams to list, you can request them by calling this operation again and setting the `ExclusiveStartDeliveryStreamName` parameter to the name of the last delivery stream returned in the last call.
 */
public suspend inline fun FirehoseClient.listDeliveryStreams(crossinline block: ListDeliveryStreamsRequest.Builder.() -> Unit): ListDeliveryStreamsResponse = listDeliveryStreams(ListDeliveryStreamsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account.
 */
public suspend inline fun FirehoseClient.listTagsForDeliveryStream(crossinline block: ListTagsForDeliveryStreamRequest.Builder.() -> Unit): ListTagsForDeliveryStreamResponse = listTagsForDeliveryStream(ListTagsForDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Writes a single data record into an Amazon Kinesis Data Firehose delivery stream. To write multiple data records into a delivery stream, use PutRecordBatch. Applications using these operations are referred to as producers.
 *
 * By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. If you use PutRecord and PutRecordBatch, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see [Amazon Kinesis Data Firehose Limits](https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
 *
 * Kinesis Data Firehose accumulates and publishes a particular metric for a customer account in one minute intervals. It is possible that the bursts of incoming bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the actual spikes in the traffic might not be fully visible in the customer's 1 minute CloudWatch metrics.
 *
 * You must specify the name of the delivery stream and the data record when using PutRecord. The data record consists of a data blob that can be up to 1,000 KiB in size, and any kind of data. For example, it can be a segment from a log file, geographic location data, website clickstream data, and so on.
 *
 * Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (`\n`) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.
 *
 * The `PutRecord` operation returns a `RecordId`, which is a unique string assigned to each record. Producer applications can use this ID for purposes such as auditability and investigation.
 *
 * If the `PutRecord` operation throws a `ServiceUnavailableException`, the API is automatically reinvoked (retried) 3 times. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.
 *
 * Re-invoking the Put API operations (for example, PutRecord and PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer time out before retrying Put API operations.
 *
 * Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it tries to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.
 *
 * Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.
 */
public suspend inline fun FirehoseClient.putRecord(crossinline block: PutRecordRequest.Builder.() -> Unit): PutRecordResponse = putRecord(PutRecordRequest.Builder().apply(block).build())

/**
 * Writes multiple data records into a delivery stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a delivery stream, use PutRecord. Applications using these operations are referred to as producers.
 *
 * Kinesis Data Firehose accumulates and publishes a particular metric for a customer account in one minute intervals. It is possible that the bursts of incoming bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the actual spikes in the traffic might not be fully visible in the customer's 1 minute CloudWatch metrics.
 *
 * For information about service quota, see [Amazon Kinesis Data Firehose Quota](https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
 *
 * Each PutRecordBatch request supports up to 500 records. Each record in the request can be as large as 1,000 KB (before base64 encoding), up to a limit of 4 MB for the entire request. These limits cannot be changed.
 *
 * You must specify the name of the delivery stream and the data record when using PutRecord. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data. For example, it could be a segment from a log file, geographic location data, website clickstream data, and so on.
 *
 * Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (`\n`) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.
 *
 * The PutRecordBatch response includes a count of failed records, `FailedPutCount`, and an array of responses, `RequestResponses`. Even if the PutRecordBatch call succeeds, the value of `FailedPutCount` may be greater than 0, indicating that there are records for which the operation didn't succeed. Each entry in the `RequestResponses` array provides additional information about the processed record. It directly correlates with a record in the request array using the same ordering, from the top to the bottom. The response array always includes the same number of records as the request array. `RequestResponses` includes both successfully and unsuccessfully processed records. Kinesis Data Firehose tries to process all records in each PutRecordBatch request. A single record failure does not stop the processing of subsequent records.
 *
 * A successfully processed record includes a `RecordId` value, which is unique for the record. An unsuccessfully processed record includes `ErrorCode` and `ErrorMessage` values. `ErrorCode` reflects the type of error, and is one of the following values: `ServiceUnavailableException` or `InternalFailure`. `ErrorMessage` provides more detailed information about the error.
 *
 * If there is an internal server error or a timeout, the write might have completed or it might have failed. If `FailedPutCount` is greater than 0, retry the request, resending only those records that might have failed processing. This minimizes the possible duplicate records and also reduces the total bytes sent (and corresponding charges). We recommend that you handle any duplicates at the destination.
 *
 * If PutRecordBatch throws `ServiceUnavailableException`, the API is automatically reinvoked (retried) 3 times. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.
 *
 * Re-invoking the Put API operations (for example, PutRecord and PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer time out before retrying Put API operations.
 *
 * Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.
 *
 * Don't concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.
 */
public suspend inline fun FirehoseClient.putRecordBatch(crossinline block: PutRecordBatchRequest.Builder.() -> Unit): PutRecordBatchResponse = putRecordBatch(PutRecordBatchRequest.Builder().apply(block).build())

/**
 * Enables server-side encryption (SSE) for the delivery stream.
 *
 * This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to `ENABLING`, and then to `ENABLED`. The encryption status of a delivery stream is the `Status` property in DeliveryStreamEncryptionConfiguration. If the operation fails, the encryption status changes to `ENABLING_FAILED`. You can continue to read and write data to your delivery stream while the encryption status is `ENABLING`, but the data is not encrypted. It can take up to 5 seconds after the encryption status changes to `ENABLED` before all records written to the delivery stream are encrypted. To find out whether a record or a batch of records was encrypted, check the response elements PutRecordOutput$Encrypted and PutRecordBatchOutput$Encrypted, respectively.
 *
 * To check the encryption status of a delivery stream, use DescribeDeliveryStream.
 *
 * Even if encryption is currently enabled for a delivery stream, you can still invoke this operation on it to change the ARN of the CMK or both its type and ARN. If you invoke this method to change the CMK, and the old CMK is of type `CUSTOMER_MANAGED_CMK`, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement. If the new CMK is of type `CUSTOMER_MANAGED_CMK`, Kinesis Data Firehose creates a grant that enables it to use the new CMK to encrypt and decrypt data and to manage the grant.
 *
 * For the KMS grant creation to be successful, Kinesis Data Firehose APIs `StartDeliveryStreamEncryption` and `CreateDeliveryStream` should not be called with session credentials that are more than 6 hours old.
 *
 * If a delivery stream already has encryption enabled and then you invoke this operation to change the ARN of the CMK or both its type and ARN and you get `ENABLING_FAILED`, this only means that the attempt to change the CMK failed. In this case, encryption remains enabled with the old CMK.
 *
 * If the encryption status of your delivery stream is `ENABLING_FAILED`, you can invoke this operation again with a valid CMK. The CMK must be enabled and the key policy mustn't explicitly deny the permission for Kinesis Data Firehose to invoke KMS encrypt and decrypt operations.
 *
 * You can enable SSE for a delivery stream only if it's a delivery stream that uses `DirectPut` as its source.
 *
 * The `StartDeliveryStreamEncryption` and `StopDeliveryStreamEncryption` operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call `StartDeliveryStreamEncryption` 13 times and `StopDeliveryStreamEncryption` 12 times for the same delivery stream in a 24-hour period.
 */
public suspend inline fun FirehoseClient.startDeliveryStreamEncryption(crossinline block: StartDeliveryStreamEncryptionRequest.Builder.() -> Unit): StartDeliveryStreamEncryptionResponse = startDeliveryStreamEncryption(StartDeliveryStreamEncryptionRequest.Builder().apply(block).build())

/**
 * Disables server-side encryption (SSE) for the delivery stream.
 *
 * This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to `DISABLING`, and then to `DISABLED`. You can continue to read and write data to your stream while its status is `DISABLING`. It can take up to 5 seconds after the encryption status changes to `DISABLED` before all records written to the delivery stream are no longer subject to encryption. To find out whether a record or a batch of records was encrypted, check the response elements PutRecordOutput$Encrypted and PutRecordBatchOutput$Encrypted, respectively.
 *
 * To check the encryption state of a delivery stream, use DescribeDeliveryStream.
 *
 * If SSE is enabled using a customer managed CMK and then you invoke `StopDeliveryStreamEncryption`, Kinesis Data Firehose schedules the related KMS grant for retirement and then retires it after it ensures that it is finished delivering records to the destination.
 *
 * The `StartDeliveryStreamEncryption` and `StopDeliveryStreamEncryption` operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call `StartDeliveryStreamEncryption` 13 times and `StopDeliveryStreamEncryption` 12 times for the same delivery stream in a 24-hour period.
 */
public suspend inline fun FirehoseClient.stopDeliveryStreamEncryption(crossinline block: StopDeliveryStreamEncryptionRequest.Builder.() -> Unit): StopDeliveryStreamEncryptionResponse = stopDeliveryStreamEncryption(StopDeliveryStreamEncryptionRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*.
 *
 * Each delivery stream can have up to 50 tags.
 *
 * This operation has a limit of five transactions per second per account.
 */
public suspend inline fun FirehoseClient.tagDeliveryStream(crossinline block: TagDeliveryStreamRequest.Builder.() -> Unit): TagDeliveryStreamResponse = tagDeliveryStream(TagDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified delivery stream. Removed tags are deleted, and you can't recover them after this operation successfully completes.
 *
 * If you specify a tag that doesn't exist, the operation ignores it.
 *
 * This operation has a limit of five transactions per second per account.
 */
public suspend inline fun FirehoseClient.untagDeliveryStream(crossinline block: UntagDeliveryStreamRequest.Builder.() -> Unit): UntagDeliveryStreamResponse = untagDeliveryStream(UntagDeliveryStreamRequest.Builder().apply(block).build())

/**
 * Updates the specified destination of the specified delivery stream.
 *
 * Use this operation to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift) or change the parameters associated with a destination (for example, to change the bucket name of the Amazon S3 destination). The update might not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are usually effective within a few minutes.
 *
 * Switching between Amazon OpenSearch Service and other services is not supported. For an Amazon OpenSearch Service destination, you can only update to another Amazon OpenSearch Service destination.
 *
 * If the destination type is the same, Kinesis Data Firehose merges the configuration parameters specified with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the call, the existing values are retained. For example, in the Amazon S3 destination, if EncryptionConfiguration is not specified, then the existing `EncryptionConfiguration` is maintained on the destination.
 *
 * If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any parameters. In this case, all parameters must be specified.
 *
 * Kinesis Data Firehose uses `CurrentDeliveryStreamVersionId` to avoid race conditions and conflicting merges. This is a required field, and the service updates the configuration only if the existing configuration has a version ID that matches. After the update is applied successfully, the version ID is updated, and can be retrieved using DescribeDeliveryStream. Use the new version ID to set `CurrentDeliveryStreamVersionId` in the next call.
 */
public suspend inline fun FirehoseClient.updateDestination(crossinline block: UpdateDestinationRequest.Builder.() -> Unit): UpdateDestinationResponse = updateDestination(UpdateDestinationRequest.Builder().apply(block).build())
