// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CodeConfiguration
import aws.sdk.kotlin.services.finspace.model.KxClusterCodeDeploymentConfiguration
import aws.sdk.kotlin.services.finspace.model.KxCommandLineArgument
import aws.sdk.kotlin.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateKxClusterCodeConfigurationOperationSerializer: HttpSerializer.NonStreaming<UpdateKxClusterCodeConfigurationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateKxClusterCodeConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.environmentId))
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("configuration"))
                add(PercentEncoding.Path.encode("code"))
            }
        }

        val payload = serializeUpdateKxClusterCodeConfigurationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateKxClusterCodeConfigurationOperationBody(context: ExecutionContext, input: UpdateKxClusterCodeConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("code"))
    val COMMANDLINEARGUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("commandLineArguments"))
    val DEPLOYMENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentConfiguration"))
    val INITIALIZATIONSCRIPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("initializationScript"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(COMMANDLINEARGUMENTS_DESCRIPTOR)
        field(DEPLOYMENTCONFIGURATION_DESCRIPTOR)
        field(INITIALIZATIONSCRIPT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.code?.let { field(CODE_DESCRIPTOR, it, ::serializeCodeConfigurationDocument) }
        if (input.commandLineArguments != null) {
            listField(COMMANDLINEARGUMENTS_DESCRIPTOR) {
                for (el0 in input.commandLineArguments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxCommandLineArgumentDocument))
                }
            }
        }
        input.deploymentConfiguration?.let { field(DEPLOYMENTCONFIGURATION_DESCRIPTOR, it, ::serializeKxClusterCodeDeploymentConfigurationDocument) }
        input.initializationScript?.let { field(INITIALIZATIONSCRIPT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
