// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CreateKxVolumeResponse
import aws.sdk.kotlin.services.finspace.model.FinspaceException
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxNas1Configuration
import aws.sdk.kotlin.services.finspace.model.KxVolumeStatus
import aws.sdk.kotlin.services.finspace.model.KxVolumeType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateKxVolumeOperationDeserializer: HttpDeserializer.NonStreaming<CreateKxVolumeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateKxVolumeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateKxVolumeError(context, call, payload)
        }
        val builder = CreateKxVolumeResponse.Builder()

        if (payload != null) {
            deserializeCreateKxVolumeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateKxVolumeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FinspaceException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> FinspaceException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateKxVolumeOperationBody(builder: CreateKxVolumeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABILITYZONEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("availabilityZoneIds"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdTimestamp"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val NAS1CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("nas1Configuration"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val VOLUMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("volumeArn"))
    val VOLUMENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("volumeName"))
    val VOLUMETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("volumeType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONEIDS_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(NAS1CONFIGURATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(VOLUMEARN_DESCRIPTOR)
        field(VOLUMENAME_DESCRIPTOR)
        field(VOLUMETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONEIDS_DESCRIPTOR.index -> builder.availabilityZoneIds =
                    deserializer.deserializeList(AVAILABILITYZONEIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AZMODE_DESCRIPTOR.index -> builder.azMode = deserializeString().let { KxAzMode.fromValue(it) }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                NAS1CONFIGURATION_DESCRIPTOR.index -> builder.nas1Configuration = deserializeKxNas1ConfigurationDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { KxVolumeStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                VOLUMEARN_DESCRIPTOR.index -> builder.volumeArn = deserializeString()
                VOLUMENAME_DESCRIPTOR.index -> builder.volumeName = deserializeString()
                VOLUMETYPE_DESCRIPTOR.index -> builder.volumeType = deserializeString().let { KxVolumeType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
