// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.CreateKxUserRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateKxUserOperationSerializer: HttpSerializer.NonStreaming<CreateKxUserRequest> {
    override fun serialize(context: ExecutionContext, input: CreateKxUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.environmentId))
                add(PercentEncoding.Path.encode("users"))
            }
        }

        val payload = serializeCreateKxUserOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateKxUserOperationBody(context: ExecutionContext, input: CreateKxUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val IAMROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iamRole"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(IAMROLE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.iamRole?.let { field(IAMROLE_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.userName?.let { field(USERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
