// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.serde

import aws.sdk.kotlin.services.finspace.model.AutoScalingConfiguration
import aws.sdk.kotlin.services.finspace.model.CapacityConfiguration
import aws.sdk.kotlin.services.finspace.model.CodeConfiguration
import aws.sdk.kotlin.services.finspace.model.CreateKxClusterRequest
import aws.sdk.kotlin.services.finspace.model.KxAzMode
import aws.sdk.kotlin.services.finspace.model.KxCacheStorageConfiguration
import aws.sdk.kotlin.services.finspace.model.KxClusterType
import aws.sdk.kotlin.services.finspace.model.KxCommandLineArgument
import aws.sdk.kotlin.services.finspace.model.KxDatabaseConfiguration
import aws.sdk.kotlin.services.finspace.model.KxSavedownStorageConfiguration
import aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration
import aws.sdk.kotlin.services.finspace.model.TickerplantLogConfiguration
import aws.sdk.kotlin.services.finspace.model.VpcConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateKxClusterOperationSerializer: HttpSerializer.NonStreaming<CreateKxClusterRequest> {
    override fun serialize(context: ExecutionContext, input: CreateKxClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("kx"))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.environmentId))
                add(PercentEncoding.Path.encode("clusters"))
            }
        }

        val payload = serializeCreateKxClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateKxClusterOperationBody(context: ExecutionContext, input: CreateKxClusterRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTOSCALINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoScalingConfiguration"))
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZoneId"))
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("azMode"))
    val CACHESTORAGECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheStorageConfigurations"))
    val CAPACITYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacityConfiguration"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CLUSTERDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterDescription"))
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterName"))
    val CLUSTERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("clusterType"))
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("code"))
    val COMMANDLINEARGUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("commandLineArguments"))
    val DATABASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("databases"))
    val EXECUTIONROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionRole"))
    val INITIALIZATIONSCRIPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("initializationScript"))
    val RELEASELABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseLabel"))
    val SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("savedownStorageConfiguration"))
    val SCALINGGROUPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scalingGroupConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TICKERPLANTLOGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tickerplantLogConfiguration"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOSCALINGCONFIGURATION_DESCRIPTOR)
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AZMODE_DESCRIPTOR)
        field(CACHESTORAGECONFIGURATIONS_DESCRIPTOR)
        field(CAPACITYCONFIGURATION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CLUSTERDESCRIPTION_DESCRIPTOR)
        field(CLUSTERNAME_DESCRIPTOR)
        field(CLUSTERTYPE_DESCRIPTOR)
        field(CODE_DESCRIPTOR)
        field(COMMANDLINEARGUMENTS_DESCRIPTOR)
        field(DATABASES_DESCRIPTOR)
        field(EXECUTIONROLE_DESCRIPTOR)
        field(INITIALIZATIONSCRIPT_DESCRIPTOR)
        field(RELEASELABEL_DESCRIPTOR)
        field(SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR)
        field(SCALINGGROUPCONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TICKERPLANTLOGCONFIGURATION_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoScalingConfiguration?.let { field(AUTOSCALINGCONFIGURATION_DESCRIPTOR, it, ::serializeAutoScalingConfigurationDocument) }
        input.availabilityZoneId?.let { field(AVAILABILITYZONEID_DESCRIPTOR, it) }
        input.azMode?.let { field(AZMODE_DESCRIPTOR, it.value) }
        if (input.cacheStorageConfigurations != null) {
            listField(CACHESTORAGECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.cacheStorageConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxCacheStorageConfigurationDocument))
                }
            }
        }
        input.capacityConfiguration?.let { field(CAPACITYCONFIGURATION_DESCRIPTOR, it, ::serializeCapacityConfigurationDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.clusterDescription?.let { field(CLUSTERDESCRIPTION_DESCRIPTOR, it) }
        input.clusterName?.let { field(CLUSTERNAME_DESCRIPTOR, it) }
        input.clusterType?.let { field(CLUSTERTYPE_DESCRIPTOR, it.value) }
        input.code?.let { field(CODE_DESCRIPTOR, it, ::serializeCodeConfigurationDocument) }
        if (input.commandLineArguments != null) {
            listField(COMMANDLINEARGUMENTS_DESCRIPTOR) {
                for (el0 in input.commandLineArguments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxCommandLineArgumentDocument))
                }
            }
        }
        if (input.databases != null) {
            listField(DATABASES_DESCRIPTOR) {
                for (el0 in input.databases) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKxDatabaseConfigurationDocument))
                }
            }
        }
        input.executionRole?.let { field(EXECUTIONROLE_DESCRIPTOR, it) }
        input.initializationScript?.let { field(INITIALIZATIONSCRIPT_DESCRIPTOR, it) }
        input.releaseLabel?.let { field(RELEASELABEL_DESCRIPTOR, it) }
        input.savedownStorageConfiguration?.let { field(SAVEDOWNSTORAGECONFIGURATION_DESCRIPTOR, it, ::serializeKxSavedownStorageConfigurationDocument) }
        input.scalingGroupConfiguration?.let { field(SCALINGGROUPCONFIGURATION_DESCRIPTOR, it, ::serializeKxScalingGroupConfigurationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.tickerplantLogConfiguration?.let { field(TICKERPLANTLOGCONFIGURATION_DESCRIPTOR, it, ::serializeTickerplantLogConfigurationDocument) }
        input.vpcConfiguration?.let { field(VPCCONFIGURATION_DESCRIPTOR, it, ::serializeVpcConfigurationDocument) }
    }
    return serializer.toByteArray()
}
