// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure that stores the capacity configuration details of a scaling group.
 */
public class KxScalingGroupConfiguration private constructor(builder: Builder) {
    /**
     * The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
     */
    public val cpu: kotlin.Double? = builder.cpu
    /**
     * An optional hard limit on the amount of memory a kdb cluster can use.
     */
    public val memoryLimit: kotlin.Int? = builder.memoryLimit
    /**
     * A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
     */
    public val memoryReservation: kotlin.Int = requireNotNull(builder.memoryReservation) { "A non-null value must be provided for memoryReservation" }
    /**
     * The number of kdb cluster nodes.
     */
    public val nodeCount: kotlin.Int = requireNotNull(builder.nodeCount) { "A non-null value must be provided for nodeCount" }
    /**
     * A unique identifier for the kdb scaling group.
     */
    public val scalingGroupName: kotlin.String = requireNotNull(builder.scalingGroupName) { "A non-null value must be provided for scalingGroupName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxScalingGroupConfiguration(")
        append("cpu=$cpu,")
        append("memoryLimit=$memoryLimit,")
        append("memoryReservation=$memoryReservation,")
        append("nodeCount=$nodeCount,")
        append("scalingGroupName=$scalingGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpu?.hashCode() ?: 0
        result = 31 * result + (memoryLimit ?: 0)
        result = 31 * result + (memoryReservation)
        result = 31 * result + (nodeCount)
        result = 31 * result + (scalingGroupName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxScalingGroupConfiguration

        if (!(cpu?.equals(other.cpu) ?: (other.cpu == null))) return false
        if (memoryLimit != other.memoryLimit) return false
        if (memoryReservation != other.memoryReservation) return false
        if (nodeCount != other.nodeCount) return false
        if (scalingGroupName != other.scalingGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
         */
        public var cpu: kotlin.Double? = null
        /**
         * An optional hard limit on the amount of memory a kdb cluster can use.
         */
        public var memoryLimit: kotlin.Int? = null
        /**
         * A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
         */
        public var memoryReservation: kotlin.Int? = null
        /**
         * The number of kdb cluster nodes.
         */
        public var nodeCount: kotlin.Int? = null
        /**
         * A unique identifier for the kdb scaling group.
         */
        public var scalingGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration) : this() {
            this.cpu = x.cpu
            this.memoryLimit = x.memoryLimit
            this.memoryReservation = x.memoryReservation
            this.nodeCount = x.nodeCount
            this.scalingGroupName = x.scalingGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxScalingGroupConfiguration = KxScalingGroupConfiguration(this)

        internal fun correctErrors(): Builder {
            if (memoryReservation == null) memoryReservation = 0
            if (nodeCount == null) nodeCount = 0
            if (scalingGroupName == null) scalingGroupName = ""
            return this
        }
    }
}
