// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment.
 */
public class KxDataviewSegmentConfiguration private constructor(builder: Builder) {
    /**
     * The database path of the data that you want to place on each selected volume for the segment. Each segment must have a unique database path for each volume.
     */
    public val dbPaths: List<String> = requireNotNull(builder.dbPaths) { "A non-null value must be provided for dbPaths" }
    /**
     * Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
     */
    public val onDemand: kotlin.Boolean = builder.onDemand
    /**
     * The name of the volume where you want to add data.
     */
    public val volumeName: kotlin.String = requireNotNull(builder.volumeName) { "A non-null value must be provided for volumeName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxDataviewSegmentConfiguration(")
        append("dbPaths=$dbPaths,")
        append("onDemand=$onDemand,")
        append("volumeName=$volumeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbPaths.hashCode()
        result = 31 * result + (onDemand.hashCode())
        result = 31 * result + (volumeName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxDataviewSegmentConfiguration

        if (dbPaths != other.dbPaths) return false
        if (onDemand != other.onDemand) return false
        if (volumeName != other.volumeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The database path of the data that you want to place on each selected volume for the segment. Each segment must have a unique database path for each volume.
         */
        public var dbPaths: List<String>? = null
        /**
         * Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
         */
        public var onDemand: kotlin.Boolean = false
        /**
         * The name of the volume where you want to add data.
         */
        public var volumeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration) : this() {
            this.dbPaths = x.dbPaths
            this.onDemand = x.onDemand
            this.volumeName = x.volumeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxDataviewSegmentConfiguration = KxDataviewSegmentConfiguration(this)

        internal fun correctErrors(): Builder {
            if (dbPaths == null) dbPaths = emptyList()
            if (volumeName == null) volumeName = ""
            return this
        }
    }
}
