// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.finspace.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The active version of the dataview that is currently in use by this cluster.
 */
public class KxDataviewActiveVersion private constructor(builder: Builder) {
    /**
     * The list of clusters that are currently using this dataview.
     */
    public val attachedClusters: List<String>? = builder.attachedClusters
    /**
     * A unique identifier for the changeset.
     */
    public val changesetId: kotlin.String? = builder.changesetId
    /**
     * The timestamp at which the dataview version was active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment.
     */
    public val segmentConfigurations: List<KxDataviewSegmentConfiguration>? = builder.segmentConfigurations
    /**
     * A unique identifier of the active version.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.finspace.model.KxDataviewActiveVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KxDataviewActiveVersion(")
        append("attachedClusters=$attachedClusters,")
        append("changesetId=$changesetId,")
        append("createdTimestamp=$createdTimestamp,")
        append("segmentConfigurations=$segmentConfigurations,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachedClusters?.hashCode() ?: 0
        result = 31 * result + (changesetId?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (segmentConfigurations?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KxDataviewActiveVersion

        if (attachedClusters != other.attachedClusters) return false
        if (changesetId != other.changesetId) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (segmentConfigurations != other.segmentConfigurations) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.finspace.model.KxDataviewActiveVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of clusters that are currently using this dataview.
         */
        public var attachedClusters: List<String>? = null
        /**
         * A unique identifier for the changeset.
         */
        public var changesetId: kotlin.String? = null
        /**
         * The timestamp at which the dataview version was active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment.
         */
        public var segmentConfigurations: List<KxDataviewSegmentConfiguration>? = null
        /**
         * A unique identifier of the active version.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.finspace.model.KxDataviewActiveVersion) : this() {
            this.attachedClusters = x.attachedClusters
            this.changesetId = x.changesetId
            this.createdTimestamp = x.createdTimestamp
            this.segmentConfigurations = x.segmentConfigurations
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.finspace.model.KxDataviewActiveVersion = KxDataviewActiveVersion(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
